/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.exception.SolverException;

public enum Operator {
    NONE,
    EQ,
    LT,
    GT,
    NQ,
    LE,
    GE,
    PL,
    MN;

    private static final THashMap<String, Operator> operators;

    public static Operator get(String name) {
        Operator op = operators.get(name);
        if (op == null) {
            throw new SolverException("Operator \"" + name + "\" is not supported.\nSupported operators are: " + operators.keySet() + "\n");
        }
        return op;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 2: {
                return "<";
            }
            case 3: {
                return ">";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return ">=";
            }
            case 4: {
                return "!=";
            }
            case 1: {
                return "=";
            }
            case 7: {
                return "+";
            }
            case 8: {
                return "-";
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String getFlip(String operator) {
        switch (Operator.get(operator).ordinal()) {
            case 2: {
                return ">";
            }
            case 3: {
                return "<";
            }
            case 5: {
                return ">=";
            }
            case 6: {
                return "<=";
            }
        }
        return operator;
    }

    public static Operator getOpposite(Operator operator) {
        switch (operator.ordinal()) {
            case 2: {
                return GE;
            }
            case 3: {
                return LE;
            }
            case 5: {
                return GT;
            }
            case 6: {
                return LT;
            }
            case 4: {
                return EQ;
            }
            case 1: {
                return NQ;
            }
            case 7: {
                return MN;
            }
            case 8: {
                return PL;
            }
        }
        throw new UnsupportedOperationException();
    }

    static {
        operators = new THashMap();
        operators.put("@", NONE);
        operators.put("=", EQ);
        operators.put(">", GT);
        operators.put(">=", GE);
        operators.put("<", LT);
        operators.put("<=", LE);
        operators.put("!=", NQ);
        operators.put("+", PL);
        operators.put("-", MN);
    }
}

