/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver;

import java.util.Arrays;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.variables.IntVar;
import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.choco.PropSumOfSquares;

public class LandscapeClass {
    protected String name;
    protected int index;
    protected RegularSquareGrid grid;
    protected int landscapeSize;
    protected int minNbPatches;
    protected int maxNbPatches;
    protected int minPatchSize;
    protected int maxPatchSize;
    protected double mesh_lb;
    protected double mesh_ub;
    protected Model model;
    protected IntVar[] patchSizes;
    protected IntVar sum;
    protected IntVar meanPatchArea;
    protected IntVar nbPatches;

    public LandscapeClass(String name, int index, RegularSquareGrid grid, Model model, int minNbPatches, int maxNbPatches, int minPatchSize, int maxPatchSize) throws FlsgenException {
        this.name = name;
        this.index = index;
        this.model = model;
        this.grid = grid;
        this.landscapeSize = grid.getNbCells();
        if (maxPatchSize < minPatchSize) {
            throw new FlsgenException("Max patch area must be greater than or equal to min patch area");
        }
        if (maxNbPatches < minNbPatches) {
            throw new FlsgenException("Max patch area must be greater than or equal to min patch area");
        }
        this.minNbPatches = minNbPatches;
        this.maxNbPatches = maxNbPatches;
        this.minPatchSize = minPatchSize;
        this.maxPatchSize = maxPatchSize;
        this.mesh_lb = -1.0;
        this.mesh_ub = -1.0;
        this.patchSizes = model.intVarArray(maxNbPatches, 0, maxPatchSize, false);
        IntVar limit = model.intVar(0, maxNbPatches - minNbPatches);
        model.count(0, this.patchSizes, limit).post();
        this.nbPatches = model.intVar(minNbPatches, maxNbPatches);
        model.arithm(this.nbPatches, "=", model.intVar(maxNbPatches), "-", limit).post();
        for (int i = 0; i < this.patchSizes.length - 1; ++i) {
            model.ifThen(model.arithm(this.patchSizes[i], "!=", 0).reify(), model.arithm(this.patchSizes[i], ">=", minPatchSize));
            model.arithm(this.patchSizes[i], "<=", this.patchSizes[i + 1]).post();
        }
        model.increasing(this.patchSizes, 0).post();
        this.sum = model.intVar(minPatchSize * minNbPatches, maxPatchSize * maxNbPatches);
        model.sum(this.patchSizes, "=", this.sum).post();
    }

    public void setMeanPatchArea(double minMeanPatchArea, double maxMeanPatchArea) throws FlsgenException {
        if (maxMeanPatchArea < minMeanPatchArea) {
            throw new FlsgenException("Max mean patch area must be greater than or equal to min mean patch area");
        }
        if (minMeanPatchArea <= 0.0) {
            throw new FlsgenException("Mean patch area target must be greater than 0");
        }
        if (minMeanPatchArea == maxMeanPatchArea) {
            System.err.println("\u001b[31mWarning: In class " + this.name + ", AREA_MN is set with a lower bound = upper bound. Note that the solver can only enforce integer division, thus the result can deviate slightly (< 1)." + "\u001b[0m");
        }
        int lb = (int)minMeanPatchArea;
        int ub = (int)(maxMeanPatchArea > minMeanPatchArea ? maxMeanPatchArea - 1.0 : maxMeanPatchArea);
        if (this.meanPatchArea == null) {
            this.meanPatchArea = this.model.intVar(lb, ub);
        }
        this.model.div(this.sum, this.nbPatches, this.meanPatchArea).post();
    }

    public void setClassArea(int minClassArea, int maxClassArea) throws FlsgenException {
        if (maxClassArea < minClassArea) {
            throw new FlsgenException("Max class area must be greater than or equal to min class area");
        }
        this.model.arithm(this.sum, ">=", minClassArea).post();
        this.model.arithm(this.sum, "<=", maxClassArea).post();
    }

    public void setLandscapeProportion(double minProportion, double maxProportion) throws FlsgenException {
        if (minProportion < 0.0 || minProportion > 100.0 || maxProportion < 0.0 || maxProportion > 100.0) {
            throw new FlsgenException("Min and max class proportion must be between 0 and 100");
        }
        if (maxProportion < minProportion) {
            throw new FlsgenException("Max proportion must be greater than or equal to min proportion");
        }
        int min = (int)((double)this.landscapeSize * minProportion / 100.0);
        int max = (int)((double)this.landscapeSize * maxProportion / 100.0);
        this.setClassArea(min, max);
    }

    public void setPatchDensity(double minDensity, double maxDensity) throws FlsgenException {
        if (maxDensity < minDensity) {
            throw new FlsgenException("Max patch density area must be greater than or equal to min patch density");
        }
        int minNbPatches = (int)(minDensity * (double)this.landscapeSize);
        int maxNbPatches = (int)(maxDensity * (double)this.landscapeSize);
        this.model.arithm(this.nbPatches, ">=", minNbPatches).post();
        this.model.arithm(this.nbPatches, "<=", maxNbPatches).post();
    }

    public void setSmallestPatchSize(int minSize, int maxSize) throws FlsgenException {
        if (maxSize < minSize) {
            throw new FlsgenException("Max SPI must be greater than or equal to min SPI");
        }
        this.model.min(this.model.intVar(minSize, maxSize), this.patchSizes).post();
    }

    public void setLargestPatchSize(int minSize, int maxSize) throws FlsgenException {
        if (maxSize < minSize) {
            throw new FlsgenException("Max LPI must be greater than or equal to min LPI");
        }
        this.model.arithm(this.patchSizes[this.patchSizes.length - 1], ">=", minSize).post();
        this.model.arithm(this.patchSizes[this.patchSizes.length - 1], "<=", maxSize).post();
    }

    public void setMesh(double mesh_lb, double mesh_ub) throws FlsgenException {
        if (mesh_ub < mesh_lb) {
            throw new FlsgenException("Max MESH must be greater than or equal to min MESH");
        }
        this.mesh_lb = mesh_lb;
        this.mesh_ub = mesh_ub;
        long netProduct_lb = (long)(mesh_lb * (double)this.landscapeSize);
        long netProduct_ub = (long)(mesh_ub * (double)this.landscapeSize);
        this.setNetProduct(netProduct_lb, netProduct_ub);
    }

    public void setNetProduct(long minNetProduct, long maxNetProduct) throws FlsgenException {
        if (maxNetProduct < minNetProduct) {
            throw new FlsgenException("Max NPRO must be greater than or equal to min NPRO");
        }
        this.model.post(new Constraint("sumOfSquares", new PropSumOfSquares(this.patchSizes, minNetProduct, maxNetProduct)));
    }

    public void setSplittingIndex(double minSplittingIndex, double maxSplittingIndex) throws FlsgenException {
        if (maxSplittingIndex < minSplittingIndex) {
            throw new FlsgenException("Max SPLI must be greater than or equal to min SPLI");
        }
        long netProductLB = (long)((double)(this.landscapeSize * this.landscapeSize) / maxSplittingIndex);
        long netProductUB = (long)((double)(this.landscapeSize * this.landscapeSize) / minSplittingIndex);
        this.setNetProduct(netProductLB, netProductUB);
    }

    public void setSplittingDensity(double minSplittingDensity, double maxSplittingDensity) throws FlsgenException {
        if (maxSplittingDensity < minSplittingDensity) {
            throw new FlsgenException("Max SDEN must be greater than or equal to min SDEN");
        }
        long netProductLB = (long)((double)this.landscapeSize / maxSplittingDensity);
        long netProductUB = (long)((double)this.landscapeSize / minSplittingDensity);
        this.setNetProduct(netProductLB, netProductUB);
    }

    public void setDegreeOfCoherence(double minCoherence, double maxCoherence) throws FlsgenException {
        if (minCoherence < 0.0 || minCoherence > 1.0 || maxCoherence < 0.0 || maxCoherence > 1.0) {
            throw new FlsgenException("Min and max coherence must be between 0 and 1");
        }
        if (maxCoherence < minCoherence) {
            throw new FlsgenException("Max COHE must be greater than or equal to min COHE");
        }
        long netProductLB = (long)(minCoherence * (double)this.landscapeSize * (double)this.landscapeSize);
        long netProductUB = (long)(maxCoherence * (double)this.landscapeSize * (double)this.landscapeSize);
        this.setNetProduct(netProductLB, netProductUB);
    }

    public void setDegreeOfDivision(double minDivision, double maxDivision) throws FlsgenException {
        if (minDivision < 0.0 || minDivision > 1.0 || maxDivision < 0.0 || maxDivision > 1.0) {
            throw new FlsgenException("Min and max degree of division must be between 0 and 1");
        }
        if (maxDivision < minDivision) {
            throw new FlsgenException("Max DIVI must be greater than or equal to min DIVI");
        }
        this.setDegreeOfCoherence(1.0 - maxDivision, 1.0 - minDivision);
    }

    public void setAllPatchesDifferentSize() {
        this.model.allDifferentUnderCondition(this.patchSizes, Condition.EXCEPT_0, true, "BC").post();
    }

    public int getNbPatches() {
        if (this.nbPatches.isInstantiated()) {
            return this.nbPatches.getValue();
        }
        return -1;
    }

    public int[] getPatchSizes() {
        return Arrays.stream(this.patchSizes).mapToInt(v -> v.isInstantiated() ? v.getValue() : -1).filter(i -> i > 0).toArray();
    }

    public double getMeanPatchArea() {
        if (this.sum.isInstantiated()) {
            return 1.0 * (double)this.sum.getValue() / (1.0 * (double)this.nbPatches.getValue());
        }
        return -1.0;
    }

    public int getTotalSize() {
        if (this.sum.isInstantiated()) {
            return this.sum.getValue();
        }
        return -1;
    }

    public double getLandscapeProportion() {
        return 100.0 * (1.0 * (double)this.getTotalSize()) / (1.0 * (double)this.landscapeSize);
    }

    public double getPatchDensity() {
        return 1.0 * (double)this.getNbPatches() / (1.0 * (double)this.landscapeSize);
    }

    public int getSmallestPatchIndex() {
        return this.getPatchSizes()[0];
    }

    public int getLargestPatchIndex() {
        return this.getPatchSizes()[this.getNbPatches() - 1];
    }

    public long getNetProduct() {
        long npro = 0L;
        for (IntVar p : this.patchSizes) {
            if (!p.isInstantiated()) {
                return -1L;
            }
            long v = new Long(p.getValue());
            npro += v * v;
        }
        return npro;
    }

    public double getMesh() {
        return 1.0 * (double)this.getNetProduct() / (1.0 * (double)this.landscapeSize);
    }

    public double getSplittingIndex() {
        return 1.0 * (double)this.landscapeSize * (double)this.landscapeSize / (1.0 * (double)this.getNetProduct());
    }

    public double getSplittingDensity() {
        return 1.0 * (double)this.landscapeSize / (1.0 * (double)this.getNetProduct());
    }

    public double getDegreeOfCoherence() {
        return 1.0 * (double)this.getNetProduct() / (1.0 * (double)this.landscapeSize * (double)this.landscapeSize);
    }

    public double getDegreeOfDivision() {
        return 1.0 - this.getDegreeOfCoherence();
    }
}

