/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.decomposition.IVectorTransformation;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class GivensRotation
implements IVectorTransformation {
    private final int lentry;
    private final int rentry;
    private final double c;
    private final double s;

    public static GivensRotation of(DataBlock vector, int lentry, int rentry) {
        return GivensRotation.of(vector, lentry, rentry, true);
    }

    public static GivensRotation of(DataBlock vector, int lentry, int rentry, boolean apply) {
        double c;
        double r;
        double s;
        double a = vector.get(lentry);
        double b = vector.get(rentry);
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        if (absb < Constants.getEpsilon()) {
            if (apply) {
                vector.set(lentry, absa);
                vector.set(rentry, 0.0);
            }
            return new GivensRotation(lentry, rentry, a < 0.0 ? 1.0 : -1.0, 0.0);
        }
        if (absa >= absb) {
            s = b / a;
            r = Math.sqrt(1.0 + s * s);
            if (a < 0.0) {
                c = -1.0 / r;
                s *= c;
                r *= -a;
            } else {
                c = 1.0 / r;
                s *= c;
                r *= a;
            }
        } else {
            c = a / b;
            r = Math.sqrt(1.0 + c * c);
            if (b < 0.0) {
                s = -1.0 / r;
                c *= s;
                r *= -b;
            } else {
                s = 1.0 / r;
                c *= s;
                r *= b;
            }
        }
        if (apply) {
            vector.set(lentry, r);
            vector.set(rentry, 0.0);
        }
        return new GivensRotation(lentry, rentry, c, s);
    }

    public static GivensRotation of(DataBlock vector, int entry) {
        return GivensRotation.of(vector, 0, entry);
    }

    public GivensRotation reverse() {
        return new GivensRotation(this.lentry, this.rentry, this.c, -this.s);
    }

    @Override
    public void transform(DataBlock vector) {
        double a = vector.get(this.lentry);
        double b = vector.get(this.rentry);
        vector.set(this.lentry, this.c * a + this.s * b);
        vector.set(this.rentry, -this.s * a + this.c * b);
    }

    @Generated
    public GivensRotation(int lentry, int rentry, double c, double s) {
        this.lentry = lentry;
        this.rentry = rentry;
        this.c = c;
        this.s = s;
    }

    @Generated
    public int getLentry() {
        return this.lentry;
    }

    @Generated
    public int getRentry() {
        return this.rentry;
    }

    @Generated
    public double getC() {
        return this.c;
    }

    @Generated
    public double getS() {
        return this.s;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GivensRotation)) {
            return false;
        }
        GivensRotation other = (GivensRotation)o;
        if (this.getLentry() != other.getLentry()) {
            return false;
        }
        if (this.getRentry() != other.getRentry()) {
            return false;
        }
        if (Double.compare(this.getC(), other.getC()) != 0) {
            return false;
        }
        return Double.compare(this.getS(), other.getS()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLentry();
        result = result * 59 + this.getRentry();
        long $c = Double.doubleToLongBits(this.getC());
        result = result * 59 + (int)($c >>> 32 ^ $c);
        long $s = Double.doubleToLongBits(this.getS());
        result = result * 59 + (int)($s >>> 32 ^ $s);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "GivensRotation(lentry=" + this.getLentry() + ", rentry=" + this.getRentry() + ", c=" + this.getC() + ", s=" + this.getS() + ")";
    }
}

