/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockStorage;

public class DataResults {
    double[] data;
    int start;
    int nused;

    public void clear() {
        this.data = null;
        this.nused = 0;
    }

    public void prepare(int start, int end) {
        this.start = start;
        this.data = new double[end - start];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Double.NaN;
        }
    }

    public DataBlock all() {
        return DataBlock.of(this.data, 0, this.nused, 1);
    }

    public DataBlock extract(int beg, int n) {
        return DataBlock.of(this.data, beg, beg + n, 1);
    }

    public double get(int t) {
        if (this.data == null || t < this.start) {
            return Double.NaN;
        }
        return this.data[t - this.start];
    }

    public boolean isMissing(int t) {
        if (this.data == null || t < this.start) {
            return true;
        }
        return Double.isNaN(this.data[t - this.start]);
    }

    public void save(int t, double x) {
        int st = t - this.start;
        if (st < 0) {
            return;
        }
        this.checkSize(st + 1);
        this.data[st] = x;
    }

    public int getStartSaving() {
        return this.start;
    }

    public void setStartSaving(int p) {
        this.start = p;
        this.data = null;
    }

    public DoubleSeq asDoublesReader(boolean complete) {
        if (complete) {
            return DoubleSeq.onMapping((int)(this.nused + this.start), i -> i < this.start ? Double.NaN : this.data[i - this.start]);
        }
        return DoubleSeq.onMapping((int)this.nused, i -> this.data[i]);
    }

    private void checkSize(int size) {
        int cursize;
        if (this.nused < size) {
            this.nused = size;
        }
        int n = cursize = this.data == null ? 0 : this.data.length;
        if (size > cursize) {
            int nsize = Math.max(DataBlockStorage.calcSize(size), cursize << 1);
            double[] tmp = new double[nsize];
            if (cursize > 0) {
                System.arraycopy(this.data, 0, tmp, 0, cursize);
            }
            for (int i = cursize; i < nsize; ++i) {
                tmp[i] = Double.NaN;
            }
            this.data = tmp;
        }
    }

    public void copyTo(double[] buffer, int start) {
        System.arraycopy(this.data, 0, buffer, start, this.nused);
    }

    public int getLength() {
        return this.nused;
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        int i = 0;
        while (i < this.nused) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }
}

