/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.stats.tests.DickeyFullerTable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DickeyFuller {
    private final double rho;
    private final double ser;
    private final double test;
    private final double pvalue;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder engleGranger(DoubleSeq x, DoubleSeq y) {
        if (x.allMatch(z -> Math.abs(z) < Constants.getEpsilon()) || y.allMatch(z -> Math.abs(z) < Constants.getEpsilon())) {
            return null;
        }
        try {
            LinearModel lm = LinearModel.builder().y(y).addX(x).meanCorrection(true).build();
            LeastSquaresResults lsr = Ols.compute(lm);
            DoubleSeq e = lsr.residuals();
            return DickeyFuller.builder().data(e);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Generated
    public DickeyFuller(double rho, double ser, double test, double pvalue) {
        this.rho = rho;
        this.ser = ser;
        this.test = test;
        this.pvalue = pvalue;
    }

    @Generated
    public double getRho() {
        return this.rho;
    }

    @Generated
    public double getSer() {
        return this.ser;
    }

    @Generated
    public double getTest() {
        return this.test;
    }

    @Generated
    public double getPvalue() {
        return this.pvalue;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DickeyFuller)) {
            return false;
        }
        DickeyFuller other = (DickeyFuller)o;
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        if (Double.compare(this.getSer(), other.getSer()) != 0) {
            return false;
        }
        if (Double.compare(this.getTest(), other.getTest()) != 0) {
            return false;
        }
        return Double.compare(this.getPvalue(), other.getPvalue()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $ser = Double.doubleToLongBits(this.getSer());
        result = result * 59 + (int)($ser >>> 32 ^ $ser);
        long $test = Double.doubleToLongBits(this.getTest());
        result = result * 59 + (int)($test >>> 32 ^ $test);
        long $pvalue = Double.doubleToLongBits(this.getPvalue());
        result = result * 59 + (int)($pvalue >>> 32 ^ $pvalue);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "DickeyFuller(rho=" + this.getRho() + ", ser=" + this.getSer() + ", test=" + this.getTest() + ", pvalue=" + this.getPvalue() + ")";
    }

    public static class Builder {
        private int k = 0;
        private DickeyFullerType type = DickeyFullerType.NC;
        private DoubleSeq y;
        private boolean pp;
        private boolean zstat;

        public Builder data(DoubleSeq y) {
            this.y = y;
            return this;
        }

        public Builder numberOfLags(int nlags) {
            if (this.k < 0) {
                throw new IllegalArgumentException("k should be greater or equal to 0");
            }
            this.k = nlags;
            return this;
        }

        public Builder type(DickeyFullerType type) {
            this.type = type;
            return this;
        }

        public Builder phillipsPerron(boolean pp) {
            this.pp = pp;
            return this;
        }

        public Builder zstat(boolean z) {
            this.zstat = z;
            return this;
        }

        public DickeyFuller build() {
            if (this.k > 0 && this.pp) {
                throw new IllegalArgumentException("nlags should be 0 with PhilipsPerron");
            }
            int n = this.y.length();
            DoubleSeq del = DoublesMath.delta((DoubleSeq)this.y, (int)1);
            int ndata = del.length() - this.k;
            int ncols = this.k + 1;
            switch (this.type.ordinal()) {
                case 1: {
                    ++ncols;
                    break;
                }
                case 2: {
                    ncols += 2;
                }
            }
            FastMatrix x = FastMatrix.make(ndata, ncols);
            DataBlockIterator columns = x.columnsIterator();
            if (this.type != DickeyFullerType.NC) {
                columns.next().set(1.0);
            }
            if (this.type == DickeyFullerType.CT) {
                columns.next().set(idx -> idx);
            }
            for (int i = 1; i <= this.k; ++i) {
                columns.next().copy(del.extract(this.k - i, ndata));
            }
            columns.next().copy(this.y.extract(this.k, ndata));
            DoubleSeq z = del.extract(this.k, ndata);
            QRLeastSquaresSolution ls = QRLeastSquaresSolver.fastLeastSquares(z, x);
            DataBlock b = DataBlock.of(ls.getB());
            double ssq = ls.getSsqErr();
            double d = b.get(ncols - 1);
            double rho = d + 1.0;
            double r = Math.abs(ls.rawRDiagonal().get(ncols - 1));
            double stdev = Math.sqrt(ssq / (double)(ndata - ncols)) / r;
            if (this.pp) {
                DataBlock u = DataBlock.of(z);
                DoubleSeqCursor c = b.cursor();
                DataBlockIterator cols = x.columnsIterator();
                while (cols.hasNext()) {
                    u.addAY(-c.getAndNext(), cols.next());
                }
                int q = (int)(4.0 * Math.pow((double)ndata * 0.01, 0.2222222222222222));
                double l = 0.0;
                for (int i = 1; i <= q; ++i) {
                    l += 2.0 * (1.0 - (double)i / ((double)q + 1.0)) * AutoCovariances.autoCovarianceNoMissing((DoubleSeq)u, (double)0.0, (int)i);
                }
                double w = (double)ndata / r;
                if (this.zstat) {
                    double stat = (double)ndata * d - 0.5 * w * w * l;
                    return new DickeyFuller(rho, stdev, stat, DickeyFullerTable.probability(ndata, stat, this.type, true));
                }
                double l0 = AutoCovariances.varianceNoMissing((DoubleSeq)u, (double)0.0);
                double ll = l0 + l;
                double stat = d / stdev * Math.sqrt(l0 / ll) - 0.5 * w * l * Math.sqrt(1.0 / ll);
                return new DickeyFuller(rho, stdev, stat, DickeyFullerTable.probability(ndata, stat, this.type, false));
            }
            if (this.zstat) {
                double stat = (double)ndata * d;
                return new DickeyFuller(rho, stdev, stat, DickeyFullerTable.probability(ndata, stat, this.type, true));
            }
            double stat = d / stdev;
            return new DickeyFuller(rho, stdev, stat, DickeyFullerTable.probability(ndata, stat, this.type, false));
        }
    }

    public static enum DickeyFullerType {
        NC,
        C,
        CT;

    }
}

