/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtosUtility;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import jdplus.tramoseats.base.api.tramo.RegressionTestType;
import jdplus.tramoseats.base.api.tramo.TradingDaysSpec;
import jdplus.tramoseats.base.protobuf.AutomaticTradingDays;
import jdplus.tramoseats.base.protobuf.TradingDaysTest;
import jdplus.tramoseats.base.protobuf.TramoSeatsProtosUtility;
import jdplus.tramoseats.base.protobuf.TramoSpec;
import lombok.Generated;

public final class TradingDaysProto {
    public static void fill(TradingDaysSpec spec, TramoSpec.TradingDaysSpec.Builder builder) {
        String holidays = spec.getHolidays();
        if (holidays != null) {
            builder.setHolidays(holidays).setLp(ModellingProtosUtility.convert((LengthOfPeriodType)spec.getLengthOfPeriodType())).setTd(ModellingProtosUtility.convert((TradingDaysType)spec.getTradingDaysType())).setAuto(TramoSeatsProtosUtility.convert(spec.getAutomaticMethod())).setTest(TramoSeatsProtosUtility.convert(spec.getRegressionTestType())).setAutoAdjust(spec.isAutoAdjust()).setPtest(spec.getProbabilityForFTest());
            return;
        }
        String[] userVariables = spec.getUserVariables();
        if (userVariables != null && userVariables.length > 0) {
            for (String v : userVariables) {
                builder.addUsers(v);
            }
            builder.setTest(TramoSeatsProtosUtility.convert(spec.getRegressionTestType()));
            return;
        }
        int w = spec.getStockTradingDays();
        if (w > 0) {
            builder.setW(w).setTest(TramoSeatsProtosUtility.convert(spec.getRegressionTestType()));
            return;
        }
        if (spec.isAutomatic()) {
            builder.setLp(ModellingProtosUtility.convert((LengthOfPeriodType)spec.getLengthOfPeriodType())).setTd(ModellingProtosUtility.convert((TradingDaysType)spec.getTradingDaysType())).setTest(TramoSeatsProtosUtility.convert(spec.getRegressionTestType())).setAuto(TramoSeatsProtosUtility.convert(spec.getAutomaticMethod())).setPtest(spec.getProbabilityForFTest());
        } else {
            builder.setLp(ModellingProtosUtility.convert((LengthOfPeriodType)spec.getLengthOfPeriodType())).setTd(ModellingProtosUtility.convert((TradingDaysType)spec.getTradingDaysType())).setTest(TramoSeatsProtosUtility.convert(spec.getRegressionTestType()));
        }
    }

    public static TramoSpec.TradingDaysSpec convert(TradingDaysSpec spec) {
        TramoSpec.TradingDaysSpec.Builder builder = TramoSpec.TradingDaysSpec.newBuilder();
        TradingDaysProto.fill(spec, builder);
        return builder.setLpcoefficient(ToolkitProtosUtility.convert((Parameter)spec.getLpCoefficient())).addAllTdcoefficients(ToolkitProtosUtility.convert((Parameter[])spec.getTdCoefficients())).build();
    }

    public static byte[] toBuffer(TradingDaysSpec spec) {
        return TradingDaysProto.convert(spec).toByteArray();
    }

    private static boolean isTest(TramoSpec.TradingDaysSpec spec) {
        return spec.getAuto() != AutomaticTradingDays.TD_AUTO_NO || spec.getTest() == TradingDaysTest.TD_TEST_JOINT_F || spec.getTest() == TradingDaysTest.TD_TEST_SEPARATE_T;
    }

    public static TradingDaysSpec convert(TramoSpec.TradingDaysSpec spec) {
        String holidays = spec.getHolidays();
        TradingDaysType td = ModellingProtosUtility.convert((ModellingProtos.TradingDays)spec.getTd());
        LengthOfPeriodType lp = ModellingProtosUtility.convert((ModellingProtos.LengthOfPeriod)spec.getLp());
        Parameter lpc = ToolkitProtosUtility.convert((ToolkitProtos.Parameter)spec.getLpcoefficient());
        Parameter[] tdc = ToolkitProtosUtility.convert(spec.getTdcoefficientsList());
        boolean test = TradingDaysProto.isTest(spec);
        if (holidays != null && holidays.length() > 0) {
            TradingDaysSpec.AutoMethod auto = TramoSeatsProtosUtility.convert(spec.getAuto());
            if (auto != TradingDaysSpec.AutoMethod.UNUSED) {
                return TradingDaysSpec.automaticHolidays((String)holidays, (LengthOfPeriodType)lp, (TradingDaysSpec.AutoMethod)auto, (double)spec.getPtest(), (boolean)spec.getAutoAdjust());
            }
            if (test) {
                return TradingDaysSpec.holidays((String)holidays, (TradingDaysType)td, (LengthOfPeriodType)lp, (RegressionTestType)TramoSeatsProtosUtility.convert(spec.getTest()), (boolean)spec.getAutoAdjust());
            }
            return TradingDaysSpec.holidays((String)holidays, (TradingDaysType)td, (LengthOfPeriodType)lp, (Parameter[])tdc, (Parameter)lpc);
        }
        int nusers = spec.getUsersCount();
        if (nusers > 0) {
            String[] users = new String[nusers];
            for (int i = 0; i < nusers; ++i) {
                users[i] = spec.getUsers(i);
            }
            if (test) {
                return TradingDaysSpec.userDefined((String[])users, (RegressionTestType)TramoSeatsProtosUtility.convert(spec.getTest()));
            }
            return TradingDaysSpec.userDefined((String[])users, (Parameter[])tdc);
        }
        int w = spec.getW();
        if (w > 0) {
            return TradingDaysSpec.stockTradingDays((int)w, (RegressionTestType)TramoSeatsProtosUtility.convert(spec.getTest()));
        }
        TradingDaysSpec.AutoMethod auto = TramoSeatsProtosUtility.convert(spec.getAuto());
        if (auto != TradingDaysSpec.AutoMethod.UNUSED) {
            return TradingDaysSpec.automatic((LengthOfPeriodType)lp, (TradingDaysSpec.AutoMethod)auto, (double)spec.getPtest(), (boolean)spec.getAutoAdjust());
        }
        if (td == TradingDaysType.NONE) {
            return TradingDaysSpec.none();
        }
        if (test) {
            return TradingDaysSpec.td((TradingDaysType)td, (LengthOfPeriodType)lp, (RegressionTestType)TramoSeatsProtosUtility.convert(spec.getTest()), (boolean)spec.getAutoAdjust());
        }
        return TradingDaysSpec.td((TradingDaysType)td, (LengthOfPeriodType)lp, (Parameter[])tdc, (Parameter)lpc);
    }

    public static TradingDaysSpec of(byte[] bytes) throws InvalidProtocolBufferException {
        TramoSpec.TradingDaysSpec spec = TramoSpec.TradingDaysSpec.parseFrom(bytes);
        return TradingDaysProto.convert(spec);
    }

    @Generated
    private TradingDaysProto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

