## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  warning = FALSE, error = FALSE, message = FALSE
)

## ----setup, echo = FALSE------------------------------------------------------
suppressPackageStartupMessages(library(PFW))

## ----download, eval = FALSE---------------------------------------------------
# pfw_download(2000:2003)

## ----import, eval = FALSE-----------------------------------------------------
# data_raw <- pfw_import(year = 2002:2003, region = "Washington")

## ----example, eval = FALSE----------------------------------------------------
# data <- pfw_example
# # or
# pfw_example

## ----update, eval = FALSE-----------------------------------------------------
# update_taxonomy()

## ----site, eval = FALSE-------------------------------------------------------
# data <- pfw_import()
# data <- pfw_sitedata(data, "data-raw/site_data.csv") # "data-raw" is once again the default path, but you can select a different path if preferred

## ----filter, eval = FALSE-----------------------------------------------------
# region_list <- c("Washington", "US-OR", "CA-BC") # Region names or abbreviations are accepted
# species_list <- c("Lawrence's Goldfinch", "Spinus tristis", "lesgol") # Common/scientific names or species codes are accepted
# data_filtered <- pfw_filter(
#   data,
#   region = region_list,
#   species = species_list,
#   year = 2002:2003,
#   month = 11:2
#   )

## ----regions, eval = FALSE----------------------------------------------------
# data_westcoast <- pfw_region(data, c("Washington", "Oregon", "California"))

## ----species, eval = FALSE----------------------------------------------------
# # Filter for Dark-eyed Junco, Song Sparrow, and Spotted Towhee
# data_my_yard <- pfw_species(data, c("Dark-eyed Junco", "Melospiza melodia", "spotow"))

## ----date, eval = FALSE-------------------------------------------------------
# data_filtered <- pfw_date(data, year = 2001:2023, month = 11:2)

## ----rollup, eval = FALSE-----------------------------------------------------
# data_rolled <- pfw_rollup(data)

## ----truncate, eval = FALSE---------------------------------------------------
# data_truncated <- pfw_truncate(data)

## ----zerofill, eval = FALSE---------------------------------------------------
# data_zf <- pfw_zerofill(data)

## ----attr, eval= FALSE--------------------------------------------------------
# pfw_attr(data)

