/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class SignificantSeasonalityTest {
    private final Position pos;
    private final double limit;

    public static int[] test(IProcResults rslts, double sig) {
        String str = InformationSet.concatenate("decomposition", "s_lin");
        TsData s = rslts.getData(str, TsData.class);
        TsData es = rslts.getData(str + "_e", TsData.class);
        TsData fs = rslts.getData(str + "_f", TsData.class);
        TsData fes = rslts.getData(str + "_ef", TsData.class);
        int[] rslt = new int[3];
        if (s != null && es != null) {
            SignificantSeasonalityTest thist = new SignificantSeasonalityTest(Position.Middle, sig);
            rslt[0] = thist.significantSeasonalFactors(s, es);
            SignificantSeasonalityTest tend = new SignificantSeasonalityTest(Position.End, sig);
            rslt[1] = tend.significantSeasonalFactors(s, es);
        } else {
            rslt[1] = -1;
            rslt[0] = -1;
        }
        if (fs != null && fes != null) {
            SignificantSeasonalityTest tfcast = new SignificantSeasonalityTest(Position.Start, sig);
            rslt[2] = tfcast.significantSeasonalFactors(fs, fes);
        } else {
            rslt[2] = -1;
        }
        return rslt;
    }

    public SignificantSeasonalityTest() {
        this.pos = Position.End;
        Normal N = new Normal();
        this.limit = N.getProbabilityInverse(0.005, ProbabilityType.Upper);
    }

    public SignificantSeasonalityTest(Position pos, double eps) {
        this.pos = pos;
        Normal N = new Normal();
        this.limit = N.getProbabilityInverse(eps / 2.0, ProbabilityType.Upper);
    }

    public int significantSeasonalFactors(TsData s, TsData es) {
        int i0 = this.start(s.getDomain());
        if (i0 < 0) {
            return -1;
        }
        int i1 = i0 + s.getFrequency().intValue();
        int ns = 0;
        for (int i = i0; i < i1; ++i) {
            if (!(Math.abs(s.get(i)) / es.get(i) > this.limit)) continue;
            ++ns;
        }
        return ns;
    }

    public boolean[] significantSeasons(TsData s, TsData es) {
        int i0 = this.start(s.getDomain());
        if (i0 < 0) {
            return null;
        }
        int f = s.getFrequency().intValue();
        boolean[] ss = new boolean[f];
        for (int j = 0; j < f; ++j) {
            ss[j] = Math.abs(s.get(i0 + j)) / es.get(i0 + j) > this.limit;
        }
        return ss;
    }

    private int start(TsDomain s) {
        int f;
        int n = s.getLength();
        if (n < (f = s.getFrequency().intValue())) {
            return -1;
        }
        switch (this.pos.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return (n - f) / 2;
            }
        }
        return n - f;
    }

    public static enum Position {
        Start,
        Middle,
        End;

    }
}

