/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.core.driftdetection.ADWIN;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;

public class LeveragingBag
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "trees.HoeffdingTree");
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models in the bag.", 10, 1, Integer.MAX_VALUE);
    public FloatOption weightShrinkOption = new FloatOption("weightShrink", 'w', "The number to use to compute the weight of new instances.", 6.0, 0.0, 3.4028234663852886E38);
    public FloatOption deltaAdwinOption = new FloatOption("deltaAdwin", 'a', "Delta of Adwin change detection", 0.002, 0.0, 1.0);
    public FlagOption outputCodesOption = new FlagOption("outputCodes", 'o', "Use Output Codes to use binary classifiers.");
    public MultiChoiceOption leveraginBagAlgorithmOption = new MultiChoiceOption("leveraginBagAlgorithm", 'm', "Leveraging Bagging to use.", new String[]{"LeveragingBag", "LeveragingBagME", "LeveragingBagHalf", "LeveragingBagWT", "LeveragingSubag"}, new String[]{"Leveraging Bagging for evolving data streams using ADWIN", "Leveraging Bagging ME using weight 1 if misclassified, otherwise error/(1-error)", "Leveraging Bagging Half using resampling without replacement half of the instances", "Leveraging Bagging WT without taking out all instances.", "Leveraging Subagging using resampling without replacement."}, 0);
    protected Classifier[] ensemble;
    protected ADWIN[] ADError;
    protected int numberOfChangesDetected;
    protected int[][] matrixCodes;
    protected boolean initMatrixCodes = false;

    public String getPurposeString() {
        return "Leveraging Bagging for evolving data streams using ADWIN.";
    }

    public void resetLearningImpl() {
        int i;
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        for (i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = baseLearner.copy();
        }
        this.ADError = new ADWIN[this.ensemble.length];
        for (i = 0; i < this.ensemble.length; ++i) {
            this.ADError[i] = new ADWIN(this.deltaAdwinOption.getValue());
        }
        this.numberOfChangesDetected = 0;
        if (this.outputCodesOption.isSet()) {
            this.initMatrixCodes = true;
        }
    }

    public void trainOnInstanceImpl(Instance inst) {
        int numClasses = inst.numClasses();
        if (this.initMatrixCodes) {
            this.matrixCodes = new int[this.ensemble.length][inst.numClasses()];
            for (int i = 0; i < this.ensemble.length; ++i) {
                int numberZeros;
                int numberOnes;
                do {
                    numberOnes = 0;
                    numberZeros = 0;
                    for (int j = 0; j < numClasses; ++j) {
                        int result = 0;
                        result = j == 1 && numClasses == 2 ? 1 - this.matrixCodes[i][0] : (this.classifierRandom.nextBoolean() ? 1 : 0);
                        this.matrixCodes[i][j] = result;
                        if (result == 1) {
                            ++numberOnes;
                            continue;
                        }
                        ++numberZeros;
                    }
                } while ((numberOnes - numberZeros) * (numberOnes - numberZeros) > this.ensemble.length % 2);
            }
            this.initMatrixCodes = false;
        }
        boolean Change = false;
        Instance weightedInst = (Instance)inst.copy();
        double w = this.weightShrinkOption.getValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            double k = 0.0;
            switch (this.leveraginBagAlgorithmOption.getChosenIndex()) {
                case 0: {
                    k = MiscUtils.poisson(w, this.classifierRandom);
                    break;
                }
                case 1: {
                    double error = this.ADError[i].getEstimation();
                    k = !this.ensemble[i].correctlyClassifies(weightedInst) ? 1.0 : (this.classifierRandom.nextDouble() < error / (1.0 - error) ? 1.0 : 0.0);
                    break;
                }
                case 2: {
                    w = 1.0;
                    k = this.classifierRandom.nextBoolean() ? 0.0 : w;
                    break;
                }
                case 3: {
                    w = 1.0;
                    k = 1.0 + (double)MiscUtils.poisson(w, this.classifierRandom);
                    break;
                }
                case 4: {
                    w = 1.0;
                    k = MiscUtils.poisson(1.0, this.classifierRandom);
                    double d = k = k > 0.0 ? w : 0.0;
                }
            }
            if (k > 0.0) {
                if (this.outputCodesOption.isSet()) {
                    weightedInst.setClassValue(this.matrixCodes[i][(int)inst.classValue()]);
                }
                weightedInst.setWeight(inst.weight() * k);
                this.ensemble[i].trainOnInstance(weightedInst);
            }
            boolean correctlyClassifies = this.ensemble[i].correctlyClassifies(weightedInst);
            double ErrEstim = this.ADError[i].getEstimation();
            if (!this.ADError[i].setInput(correctlyClassifies ? 0.0 : 1.0) || !(this.ADError[i].getEstimation() > ErrEstim)) continue;
            Change = true;
        }
        if (Change) {
            ++this.numberOfChangesDetected;
            double max = 0.0;
            int imax = -1;
            for (int i = 0; i < this.ensemble.length; ++i) {
                if (!(max < this.ADError[i].getEstimation())) continue;
                max = this.ADError[i].getEstimation();
                imax = i;
            }
            if (imax != -1) {
                this.ensemble[imax].resetLearning();
                this.ADError[imax] = new ADWIN(this.deltaAdwinOption.getValue());
            }
        }
    }

    public double[] getVotesForInstance(Instance inst) {
        if (this.outputCodesOption.isSet()) {
            return this.getVotesForInstanceBinary(inst);
        }
        DoubleVector combinedVote = new DoubleVector();
        for (int i = 0; i < this.ensemble.length; ++i) {
            DoubleVector vote = new DoubleVector(this.ensemble[i].getVotesForInstance(inst));
            if (!(vote.sumOfValues() > 0.0)) continue;
            vote.normalize();
            combinedVote.addValues(vote);
        }
        return combinedVote.getArrayRef();
    }

    public double[] getVotesForInstanceBinary(Instance inst) {
        double[] combinedVote = new double[inst.numClasses()];
        Instance weightedInst = (Instance)inst.copy();
        if (!this.initMatrixCodes) {
            for (int i = 0; i < this.ensemble.length; ++i) {
                weightedInst.setClassValue(this.matrixCodes[i][(int)inst.classValue()]);
                double[] vote = this.ensemble[i].getVotesForInstance(weightedInst);
                int voteClass = 0;
                if (vote.length == 2) {
                    voteClass = vote[1] > vote[0] ? 1 : 0;
                }
                for (int j = 0; j < inst.numClasses(); ++j) {
                    if (this.matrixCodes[i][j] != voteClass) continue;
                    int n = j;
                    combinedVote[n] = combinedVote[n] + 1.0;
                }
            }
        }
        return combinedVote;
    }

    public boolean isRandomizable() {
        return true;
    }

    public void getModelDescription(StringBuilder out, int indent) {
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("ensemble size", this.ensemble != null ? (double)this.ensemble.length : 0.0), new Measurement("change detections", this.numberOfChangesDetected)};
    }

    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.ensemble.clone();
    }
}

