/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.formats.muc.RawCorefSample;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullParseCorefEnhancerStream
extends FilterObjectStream<RawCorefSample, RawCorefSample> {
    private final Parser parser;

    public FullParseCorefEnhancerStream(Parser parser, ObjectStream<RawCorefSample> samples) {
        super(samples);
        this.parser = parser;
    }

    static Parse createIncompleteParse(String[] tokens) {
        Span[] tokenSpans = new Span[tokens.length];
        StringBuilder textBuilder = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (textBuilder.length() > 0) {
                textBuilder.append(' ');
            }
            int startOffset = textBuilder.length();
            textBuilder.append(tokens[i]);
            tokenSpans[i] = new Span(startOffset, textBuilder.length());
        }
        String text = textBuilder.toString();
        Parse p = new Parse(text, new Span(0, text.length()), "INC", 0.0, 0);
        for (int i = 0; i < tokenSpans.length; ++i) {
            Span tokenSpan = tokenSpans[i];
            p.insert(new Parse(text, new Span(tokenSpan.getStart(), tokenSpan.getEnd()), "TK", 0.0, i));
        }
        return p;
    }

    @Override
    public RawCorefSample read() throws IOException {
        RawCorefSample sample = (RawCorefSample)this.samples.read();
        if (sample != null) {
            ArrayList<Parse> enhancedParses = new ArrayList<Parse>();
            List<String[]> sentences = sample.getTexts();
            for (int i = 0; i < sentences.size(); ++i) {
                String[] sentence = sentences.get(i);
                Parse incompleteParse = FullParseCorefEnhancerStream.createIncompleteParse(sentence);
                Parse p = this.parser.parse(incompleteParse);
                enhancedParses.add(p);
            }
            sample.setParses(enhancedParses);
            return sample;
        }
        return null;
    }
}

