/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.od;

import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.od.OdCell;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.com.github.miachm.sods.Range;

final class OdSheet
extends Sheet {
    private static final int BUGGED_COLUMN_COUNT = 16384;
    private final String name;
    private final Range sheet;
    private final int columnCount;
    private final ZoneId zoneId;
    @Deprecated
    private final OdCell flyweightCell;

    public OdSheet(standalone_spreadsheet.com.github.miachm.sods.Sheet sheet) {
        this.name = sheet.getName();
        this.sheet = sheet.getDataRange();
        this.columnCount = OdSheet.computeColumnCount(this.sheet);
        this.zoneId = ZoneId.systemDefault();
        this.flyweightCell = new OdCell(this.zoneId);
    }

    static int computeColumnCount(Range sheet) {
        if (sheet.getNumRows() == 0) {
            return 0;
        }
        int result = sheet.getNumColumns();
        if (result != 16384) {
            return result;
        }
        int min = 0;
        int max = 16384;
        do {
            if (!OdSheet.isNullOrEmpty(sheet, 0, result = (min + max) / 2)) {
                min = result + 1;
                continue;
            }
            max = result - 1;
        } while (min <= max);
        return result + 1;
    }

    static boolean isNullOrEmpty(Range sheet, int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
        return sheet.getCell(rowIdx, columnIdx).getValue() == null;
    }

    static Date toDate(LocalDateTime value, ZoneId zoneId) {
        return Date.from(value.atZone(zoneId).toInstant());
    }

    static Date toDate(LocalDate value, ZoneId zoneId) {
        return Date.from(value.atStartOfDay(zoneId).toInstant());
    }

    public int getRowCount() {
        return this.sheet.getNumRows();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Cell getCell(int rowIdx, int columnIdx) {
        Object value = this.sheet.getCell(rowIdx, columnIdx).getValue();
        return value != null ? this.flyweightCell.withValue(value) : null;
    }

    public @Nullable Object getCellValue(int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
        Object value = this.sheet.getCell(rowIdx, columnIdx).getValue();
        if (value instanceof LocalDateTime) {
            return OdSheet.toDate((LocalDateTime)value, this.zoneId);
        }
        if (value instanceof LocalDate) {
            return OdSheet.toDate((LocalDate)value, this.zoneId);
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        return null;
    }

    @NonNull
    public String getName() {
        return this.name.replace("_", " ");
    }
}

