/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.StateStorage;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.basic.DummyInitialization;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DiffuseSquareRootInitializer;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import jdplus.toolkit.base.core.ssf.univariate.SsfDataWindow;

public class FixedPointSmoother {
    private final ISsf ssf;
    private final int fixpos;
    private final FastMatrix M;
    private StateStorage states;

    public StateStorage getResults() {
        return this.states;
    }

    public FixedPointSmoother(ISsf ssf, int fixpos) {
        this.ssf = ssf;
        this.fixpos = fixpos;
        this.M = null;
    }

    public FixedPointSmoother(ISsf ssf, int fixpos, FastMatrix M) {
        if (M != null && ssf.getStateDim() != M.getColumnsCount()) {
            throw new SsfException("Invalid fixed point argument");
        }
        this.ssf = ssf;
        this.fixpos = fixpos;
        this.M = M;
    }

    public FastMatrix getTransformationMatrix() {
        return this.M;
    }

    public int getFixedPointPosition() {
        return this.fixpos;
    }

    public boolean process(ISsfData data) {
        OrdinaryFilter filter = new OrdinaryFilter(new Initializer(this.ssf, this.fixpos, this.M));
        SsfDataWindow xdata = new SsfDataWindow(data, this.fixpos, data.length());
        int mdim = this.M == null ? this.ssf.getStateDim() : this.M.getRowsCount();
        Ssf xssf = Ssf.of((ISsfInitialization)new DummyInitialization(mdim + this.ssf.getStateDim()), (ISsfDynamics)new Dynamics(this.ssf, mdim), (ISsfLoading)new Loading(this.ssf, mdim), this.ssf.measurementError());
        this.states = StateStorage.full(StateInfo.Concurrent);
        this.states.prepare(mdim, this.fixpos, data.length());
        Results frslts = new Results(this.states, this.ssf.getStateDim(), mdim);
        return filter.process(xssf, xdata, frslts);
    }

    static class Initializer
    implements OrdinaryFilter.Initializer {
        private final int fixpos;
        private final FastMatrix M;
        private final ISsf core;

        Initializer(ISsf core, int fixpos, FastMatrix M) {
            this.fixpos = fixpos;
            this.M = M;
            this.core = core;
        }

        @Override
        public int initializeFilter(State state, ISsf ssf, ISsfData data) {
            DiffuseSquareRootInitializer init = new DiffuseSquareRootInitializer(null);
            OrdinaryFilter filter = new OrdinaryFilter(init);
            SsfDataWindow data0 = new SsfDataWindow(data, 0, this.fixpos);
            filter.process(this.core, data, null);
            if (init.getEndDiffusePos() > this.fixpos) {
                return -1;
            }
            int r = this.core.getStateDim();
            DataBlock a = filter.getFinalState().a();
            FastMatrix P = filter.getFinalState().P();
            state.a().range(0, r).copy(a);
            MatrixWindow cur = state.P().topLeft(0, 0);
            cur.next(r, r).copy(P);
            if (this.M == null) {
                state.a().range(r, 2 * r).copy(a);
                cur.vnext(r).copy(P);
                cur.hnext(r).copy(P);
                cur.vprevious(r).copy(P);
            } else {
                int m = this.M.getRowsCount();
                state.a().range(r, r + m).product(this.M.rowsIterator(), a);
                GeneralMatrix.setAB(this.M, P, cur.vnext(r));
                SymmetricMatrix.XSXt(P, this.M, cur.hnext(r));
                GeneralMatrix.setAB(this.M, P, cur.vprevious(r));
            }
            return this.fixpos;
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final ISsfDynamics core;
        private final int cdim;
        private final int mdim;

        Dynamics(ISsf ssf, int mdim) {
            this.core = ssf.dynamics();
            this.mdim = mdim;
            this.cdim = ssf.getStateDim();
        }

        @Override
        public int getInnovationsDim() {
            return this.core.getInnovationsDim();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            this.core.V(pos, qm.extract(0, this.cdim, 0, this.cdim));
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            this.core.S(pos, cm.extract(0, this.cdim, 0, cm.getColumnsCount()));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.core.hasInnovations(pos);
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.core.areInnovationsTimeInvariant();
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.core.T(pos, tr.extract(0, this.cdim, 0, this.cdim));
            tr.diagonal().range(tr.getRowsCount() - this.mdim, tr.getRowsCount()).set(1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            this.core.TX(pos, x.range(0, this.cdim));
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            this.core.addV(pos, p.extract(0, this.cdim, 0, this.cdim));
        }

        @Override
        public void XT(int pos, DataBlock x) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isTimeInvariant() {
            return this.core.isTimeInvariant();
        }
    }

    static class Loading
    implements ISsfLoading {
        private final ISsfLoading core;
        private final int cdim;
        private final int mdim;

        Loading(ISsf ssf, int mdim) {
            this.core = ssf.loading();
            this.mdim = mdim;
            this.cdim = ssf.getStateDim();
        }

        @Override
        public void Z(int pos, DataBlock z) {
            this.core.Z(pos, z.range(0, this.cdim));
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return this.core.ZX(pos, m.range(0, this.cdim));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return this.core.ZVZ(pos, V.extract(0, this.cdim, 0, this.cdim));
        }

        @Override
        public boolean isTimeInvariant() {
            return this.core.isTimeInvariant();
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class Results
    implements IFilteringResults {
        private final StateStorage states;
        private final int start;
        private final int n;

        Results(StateStorage states, int start, int n) {
            this.states = states;
            this.start = start;
            this.n = n;
        }

        @Override
        public void save(int t, UpdateInformation pe) {
        }

        @Override
        public void clear() {
            this.states.clear();
        }

        @Override
        public void save(int pos, State state, StateInfo info) {
            if (info == StateInfo.Forecast) {
                this.states.save(pos, state.a().extract(this.start, this.n), state.P().extract(this.start, this.n, this.start, this.n));
            }
        }
    }
}

