/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.search.FPNode;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

class FPTree {
    public List<FPNode> frequentHeaderNodes;
    public FPNode.FPTreeNode root;
    private SDMap sdmap;

    private FPTree(List<FPNode> frequentHeaderNodes, FPNode.FPTreeNode root, SDMap sdmap) {
        this.frequentHeaderNodes = frequentHeaderNodes;
        this.root = root;
        this.sdmap = sdmap;
    }

    public FPTree(Collection<? extends SGSelector> selectorSet, Iterable<DataRecord> instanceIteration, boolean pruneFrequentItems, SDMap sdmap) {
        this.sdmap = sdmap;
        this.frequentHeaderNodes = this.createFrequentItemNodeList(selectorSet, instanceIteration, pruneFrequentItems);
        this.root = new FPNode.FPTreeNode(null);
        if (!this.frequentHeaderNodes.isEmpty()) {
            for (DataRecord inst : instanceIteration) {
                this.insertIntoTree(inst, sdmap.target);
                if (!sdmap.aborted) continue;
                return;
            }
        }
    }

    private StringBuffer printTree(FPNode.FPTreeNode node, int depth, StringBuffer buffy) {
        int i = 0;
        while (i < depth) {
            buffy.append("|");
            ++i;
        }
        if (node.sel != null) {
            buffy.append(node.toString());
        }
        buffy.append("\n");
        for (FPNode.FPTreeNode child : node.children) {
            this.printTree(child, depth + 1, buffy);
        }
        return buffy;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("Frequent Selectors: " + this.frequentHeaderNodes);
        buffy = this.printTree(this.root, 0, buffy);
        return buffy.toString();
    }

    public Collection<Attribute> extractFrequentAttributes() {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (FPNode n : this.frequentHeaderNodes) {
            attributes.add(n.sel.getAttribute());
        }
        return attributes;
    }

    public FPNode findMostUnfrequentFPNode(Collection<SGSelector> selectors) {
        ArrayList<FPNode> freqHeaderNodes = new ArrayList<FPNode>(this.frequentHeaderNodes);
        FPTree.sortFrequentNodesAscending(freqHeaderNodes);
        for (FPNode n : freqHeaderNodes) {
            if (!selectors.contains(n.sel)) continue;
            return n;
        }
        return null;
    }

    static void sortFrequentNodesDescending(List<FPNode> nodes) {
        Collections.sort(nodes, new Comparator<FPNode>(){

            @Override
            public int compare(FPNode n1, FPNode n2) {
                if (n1.n == n2.n) {
                    return 0;
                }
                return n1.n < n2.n ? 1 : -1;
            }
        });
    }

    static void sortFrequentNodesAscending(List<FPNode> nodes) {
        Collections.sort(nodes, new Comparator<FPNode>(){

            @Override
            public int compare(FPNode n1, FPNode n2) {
                if (n1.n == n2.n) {
                    return 0;
                }
                return n1.n > n2.n ? 1 : -1;
            }
        });
    }

    public boolean containsAnyAttribute(Set<Attribute> attributes) {
        for (FPNode node : this.frequentHeaderNodes) {
            for (Attribute a : attributes) {
                if (node.sel.getAttribute() != a) continue;
                return true;
            }
        }
        return false;
    }

    public FPNode getFPNodeWithSameAttributeAsSelector(SGSelector sel) {
        for (FPNode n : this.frequentHeaderNodes) {
            if (n.sel.getAttribute() != sel.getAttribute()) continue;
            return n;
        }
        return null;
    }

    public FPNode getFPNodeForSelector(SGSelector sel) {
        for (FPNode n : this.frequentHeaderNodes) {
            if (n.sel != sel) continue;
            return n;
        }
        return null;
    }

    public FPTree buildConditionalFPTree(FPNode headerNode) {
        List<? extends FPNode.FPTreePath> paths = headerNode.getAllPrefixPaths();
        FPTree conditionalTree = this.buildConditionalFPTree(paths);
        return conditionalTree;
    }

    private FPTree buildConditionalFPTree(List<? extends FPNode.FPTreePath> conditionalPaths) {
        Map<SGSelector, FPNode> frequentNodesMap = FPTree.collectFrequentNodesMapFromPaths(conditionalPaths);
        List<FPNode> frequentNodes = this.pruneAndSortFrequentNodesMapDescending(frequentNodesMap, true);
        if (frequentNodes.isEmpty()) {
            return null;
        }
        FPTree tree = new FPTree(frequentNodes, new FPNode.FPTreeNode(null), this.sdmap);
        tree.insertPathsIntoConditionalTree(conditionalPaths, frequentNodes);
        return tree;
    }

    private void insertPathsIntoConditionalTree(List conditionalPaths, List frequentNodes) {
        block0: for (FPNode.FPTreePath path : conditionalPaths) {
            FPNode.FPTreeNode activeNode = this.root;
            for (FPNode aFrequentNode : frequentNodes) {
                SGSelector sel = aFrequentNode.sel;
                if (path.selectors.remove(sel)) {
                    FPNode.FPTreeNode child = activeNode.getChildForSelector(sel);
                    if (child == null) {
                        child = new FPNode.FPTreeNode(sel);
                        this.insertIntoFrequentNodes(aFrequentNode, child);
                        activeNode.children.add(child);
                        child.parent = activeNode;
                    }
                    child.tp += path.tp;
                    child.n += path.n;
                    activeNode = child;
                }
                if (path.selectors.isEmpty()) continue block0;
            }
        }
    }

    private void insertIntoFrequentNodes(FPNode freqNode, FPNode.FPTreeNode node) {
        if (freqNode.sel != node.sel) {
            throw new IllegalStateException("Wrong freqNode for FPTreeNode ...");
        }
        freqNode.siblings.add(node);
    }

    private List<FPNode> pruneAndSortFrequentNodesMapDescending(Map<SGSelector, FPNode> frequentNodesMap, boolean pruneFrequentItems) {
        if (pruneFrequentItems) {
            KBestSGSet resultSet = this.sdmap.result;
            Iterator<FPNode> iter = frequentNodesMap.values().iterator();
            while (iter.hasNext()) {
                FPNode node = iter.next();
                boolean isTargetBoolean = this.sdmap.target.isBoolean();
                if (isTargetBoolean && !this.sdmap.fullfillsMinSupportBooleanTarget(node.tp, node.n)) {
                    iter.remove();
                    continue;
                }
                if (!isTargetBoolean && node.n < this.sdmap.task.getMinSubgroupSize()) {
                    iter.remove();
                    continue;
                }
                double estimateQuality = this.sdmap.getOptimisticEstimate(node.n, node.tp, this.sdmap.totalPopulationSize, this.sdmap.definedPositives);
                if (!isTargetBoolean || resultSet == null || resultSet.isInKBestQualityRange(estimateQuality)) continue;
                iter.remove();
            }
        }
        ArrayList<FPNode> result = new ArrayList<FPNode>(frequentNodesMap.values());
        FPTree.sortFrequentNodesDescending(result);
        return result;
    }

    private static Map<SGSelector, FPNode> collectFrequentNodesMapFromPaths(List<? extends FPNode.FPTreePath> conditionalPaths) {
        HashMap<SGSelector, FPNode> frequentNodesMap = new HashMap<SGSelector, FPNode>();
        for (FPNode.FPTreePath fPTreePath : conditionalPaths) {
            for (SGSelector sel : fPTreePath.selectors) {
                FPNode node = (FPNode)frequentNodesMap.get(sel);
                if (node == null) {
                    node = new FPNode(sel);
                    frequentNodesMap.put(sel, node);
                }
                node.tp += fPTreePath.tp;
                node.n += fPTreePath.n;
            }
        }
        return frequentNodesMap;
    }

    private void insertIntoTree(DataRecord inst, SGTarget target) {
        FPNode.FPTreeNode activeNode = this.root;
        for (FPNode node : this.frequentHeaderNodes) {
            SGSelector sel = node.sel;
            if (!sel.isContainedInInstance(inst)) continue;
            FPNode.FPTreeNode child = activeNode.getChildForSelector(sel);
            if (child == null) {
                child = new FPNode.FPTreeNode(sel);
                this.insertIntoFrequentNodes(node, child);
                activeNode.children.add(child);
                child.parent = activeNode;
            }
            child.n += inst.getWeight();
            if (target instanceof BooleanTarget) {
                if (((BooleanTarget)target).isPositive(inst)) {
                    child.tp += inst.getWeight();
                }
            } else if (target instanceof NumericTarget) {
                child.tp += ((NumericTarget)target).getValue(inst) * inst.getWeight();
            }
            activeNode = child;
        }
    }

    private List<FPNode> createFrequentItemNodeList(Collection<? extends SGSelector> selectorSet, Iterable<DataRecord> instanceIteration, boolean pruneFrequentItems) {
        HashMap<SGSelector, FPNode> frequentNodesMap = new HashMap<SGSelector, FPNode>();
        SGTarget target = this.sdmap.target;
        for (DataRecord inst : instanceIteration) {
            for (SGSelector sGSelector : selectorSet) {
                if (!sGSelector.isContainedInInstance(inst)) continue;
                FPNode node = (FPNode)frequentNodesMap.get(sGSelector);
                if (node == null) {
                    node = new FPNode(sGSelector);
                    frequentNodesMap.put(sGSelector, node);
                }
                node.n += inst.getWeight();
                if (target instanceof BooleanTarget) {
                    if (!((BooleanTarget)target).isPositive(inst)) continue;
                    node.tp += inst.getWeight();
                    continue;
                }
                if (!(target instanceof NumericTarget)) continue;
                double value = ((NumericTarget)target).getValue(inst);
                node.tp += value * inst.getWeight();
            }
            if (this.sdmap.aborted) break;
        }
        return this.pruneAndSortFrequentNodesMapDescending(frequentNodesMap, pruneFrequentItems);
    }

    public boolean treeHasSinglePath() {
        FPNode.FPTreeNode node = this.root;
        while (!node.children.isEmpty()) {
            if (node.children.size() > 1) {
                return false;
            }
            node = node.children.get(0);
        }
        return true;
    }

    public List<FPNode> getFrequentHeaderNodes() {
        return this.frequentHeaderNodes;
    }
}

