/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.cholette;

import ec.benchmarking.cholette.ISummation;
import ec.benchmarking.cholette.IVariance;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class MultiplicativeCholetteMethod {
    private ISummation sum_;
    private IVariance var_;
    private double[] x_;
    private Matrix xVar_;

    public MultiplicativeCholetteMethod(IVariance var, ISummation sum) {
        this.sum_ = sum;
        this.var_ = var;
    }

    public double[] getResult() {
        return this.x_;
    }

    public Matrix getVar() {
        return this.xVar_;
    }

    public boolean process(DataBlock y, DataBlock z) {
        try {
            int i;
            int i2;
            Matrix svs = SymmetricMatrix.inverse(this.sum_.BAB(this.var_));
            double[] One = new double[this.sum_.dim()];
            DataBlock C = new DataBlock(One);
            C.set(1.0);
            double[] sone = new double[this.sum_.sdim()];
            for (int i3 = 0; i3 < sone.length; ++i3) {
                sone[i3] = this.sum_.Btz(i3, C);
            }
            double h = SymmetricMatrix.quadraticForm(svs, sone);
            double[] r = new double[y.getLength()];
            y.copyTo(r, 0);
            this.x_ = new double[this.sum_.dim()];
            if (z.getLength() > 0) {
                z.copyTo(this.x_, 0);
                for (int i4 = 0; i4 < r.length; ++i4) {
                    int n = i4;
                    r[n] = r[n] - this.sum_.Btz(i4, z);
                }
            }
            DataBlock tmp = new DataBlock(this.sum_.sdim());
            tmp.product(svs.rows(), new DataBlock(r));
            double s = 0.0;
            for (int i5 = 0; i5 < this.sum_.dim(); ++i5) {
                s += this.sum_.Bx(i5, tmp);
            }
            double m = -s / h;
            int i6 = 0;
            while (i6 < this.x_.length) {
                int n = i6++;
                this.x_[n] = this.x_[n] - m;
            }
            y.copyTo(r, 0);
            DataBlock XM = new DataBlock(this.x_);
            if (z.getLength() > 0) {
                for (i2 = 0; i2 < r.length; ++i2) {
                    int n = i2;
                    r[n] = r[n] - this.sum_.Btz(i2, XM);
                }
            } else {
                C.set(m);
                for (i2 = 0; i2 < r.length; ++i2) {
                    int n = i2;
                    r[n] = r[n] + this.sum_.Btz(i2, C);
                }
            }
            tmp.product(svs.rows(), new DataBlock(r));
            double[] xtmp = new double[this.x_.length];
            for (i = 0; i < xtmp.length; ++i) {
                xtmp[i] = this.sum_.Bx(i, tmp);
            }
            i = 0;
            while (i < xtmp.length) {
                double vs = 0.0;
                for (int j = 0; j < xtmp.length; ++j) {
                    vs += xtmp[j] * this.var_.var(i, j);
                }
                int n = i++;
                this.x_[n] = this.x_[n] + vs;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

