/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.http.HttpConnectionHook;
import com.qarks.util.http.HttpHandler;
import com.qarks.util.http.HttpHeader;
import com.qarks.util.http.HttpRequest;
import com.qarks.util.http.HttpResponse;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class LightWebServer {
    private ServerListener server;
    private ExecutorService threadQueue;
    private int readTimeout = 15000;
    private Hashtable handlers = new Hashtable();
    private HttpHandler fileHandler = null;
    private String name;
    private SSLContext sslContext = null;
    private HttpConnectionHook connectionHook;

    public LightWebServer(String string, int n) {
        this(string, n, false, 10);
    }

    public LightWebServer(String string) {
        this(string, 8080, false, 10);
    }

    public LightWebServer(String string, int n, boolean bl) {
        this(string, n, bl, 10);
    }

    public LightWebServer(String string, int n, int n2) {
        this(string, n, false, n2);
    }

    public LightWebServer(String string, int n, boolean bl, int n2) {
        this.name = string;
        if (n > 0) {
            this.server = new ServerListener(n, bl);
        }
        this.threadQueue = Executors.newFixedThreadPool(n2);
    }

    public void setSSLContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
    }

    public void setFileHandler(HttpHandler httpHandler) {
        this.fileHandler = httpHandler;
    }

    public void setConnectionHook(HttpConnectionHook httpConnectionHook) {
        this.connectionHook = httpConnectionHook;
    }

    public void addHandler(HttpHandler httpHandler) {
        this.handlers.put(httpHandler.getName(), httpHandler);
    }

    public void start() throws IOException {
        try {
            if (this.server != null) {
                this.server.startListening();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void dispose() {
        if (this.server != null) {
            this.server.close();
        }
        this.threadQueue.shutdown();
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    protected boolean handleRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
        boolean bl = false;
        HttpHandler httpHandler = this.getHandler(httpRequest);
        if (httpHandler != null) {
            try {
                httpHandler.handleRequest(httpRequest, httpResponse);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bl = true;
        }
        return bl;
    }

    protected HttpHandler getHandler(HttpRequest httpRequest) {
        String string = httpRequest.getResourceName();
        HttpHandler httpHandler = (HttpHandler)this.handlers.get(string);
        return httpHandler;
    }

    public static String readRequestHeader(InputStream inputStream) throws IOException {
        String string = "";
        byte[] byArray = new byte[50000];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (!bl && n2 > -1) {
            n2 = inputStream.read(byArray, n, 1);
            if (n2 != 1 || !(bl = byArray[++n - 1] == 10 && byArray[n - 2] == 13 && byArray[n - 3] == 10 && byArray[n - 4] == 13)) continue;
            string = new String(byArray, 0, n, "ASCII");
        }
        return string;
    }

    private class ClientRequestProcessor
    implements Runnable {
        private Socket clientSocket;
        private int timeout;

        public ClientRequestProcessor(Socket socket, int n) {
            this.clientSocket = socket;
            this.timeout = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream outputStream = null;
            String string = null;
            HttpResponse httpResponse = null;
            try {
                this.clientSocket.setSoTimeout(this.timeout);
                InputStream inputStream = this.clientSocket.getInputStream();
                OutputStream outputStream2 = this.clientSocket.getOutputStream();
                outputStream = new BufferedOutputStream(outputStream2);
                String string2 = LightWebServer.readRequestHeader(inputStream);
                HttpHeader httpHeader = HttpHeader.fromString(string2);
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.clientSocket.getRemoteSocketAddress();
                String string3 = inetSocketAddress.getAddress().getHostAddress();
                String string4 = inetSocketAddress.getHostName();
                HttpRequest httpRequest = new HttpRequest(httpHeader, inputStream, string3, string4);
                httpResponse = new HttpResponse(outputStream);
                string = httpRequest.getResourceName();
                if (!LightWebServer.this.handleRequest(httpRequest, httpResponse)) {
                    if (LightWebServer.this.fileHandler != null) {
                        LightWebServer.this.fileHandler.handleRequest(httpRequest, httpResponse);
                    } else {
                        httpResponse.sendErrorCode("HTTP/1.0 500");
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error while serving " + string + ": " + exception.getMessage());
                if (httpResponse != null) {
                    try {
                        httpResponse.sendErrorCode("HTTP/1.0 500");
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (this.clientSocket != null) {
                        this.clientSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class ServerListener
    extends Thread {
        private ServerSocket server;
        private int port;
        private boolean secure;

        public ServerListener(int n, boolean bl) {
            this.port = n;
            this.secure = bl;
        }

        public ServerListener(int n) {
            this(n, false);
        }

        public void startListening() throws Exception {
            if (this.server == null) {
                if (this.secure) {
                    if (LightWebServer.this.sslContext == null) {
                        ServerSocketFactory serverSocketFactory = SSLServerSocketFactory.getDefault();
                        this.server = serverSocketFactory.createServerSocket(this.port);
                    } else {
                        SSLServerSocketFactory sSLServerSocketFactory = LightWebServer.this.sslContext.getServerSocketFactory();
                        this.server = sSLServerSocketFactory.createServerSocket(this.port);
                    }
                } else {
                    this.server = new ServerSocket(this.port);
                }
                this.start();
            }
        }

        public void close() {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rejectConnection(Socket socket) {
            FilterOutputStream filterOutputStream = null;
            try {
                OutputStream outputStream = socket.getOutputStream();
                filterOutputStream = new BufferedOutputStream(outputStream);
                HttpResponse httpResponse = new HttpResponse(filterOutputStream);
                httpResponse.sendErrorCode("HTTP/1.0 403");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    socket.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public void run() {
            System.out.println(LightWebServer.this.name + " server listening on port " + this.port);
            while (!this.server.isClosed()) {
                try {
                    Socket socket = this.server.accept();
                    boolean bl = true;
                    if (LightWebServer.this.connectionHook != null) {
                        bl = LightWebServer.this.connectionHook.accept(socket);
                    }
                    if (bl) {
                        ClientRequestProcessor clientRequestProcessor = new ClientRequestProcessor(socket, LightWebServer.this.readTimeout);
                        LightWebServer.this.threadQueue.submit(clientRequestProcessor);
                        continue;
                    }
                    this.rejectConnection(socket);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

