/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Real2;

public class Vector2
extends Real2 {
    public Vector2(Real2 r) {
        super(r);
    }

    public Vector2(double x, double y) {
        this(new Real2(x, y));
    }

    public Angle getAngleMadeWith(Vector2 v) {
        Angle angle = null;
        if (v != null) {
            double theta0 = Math.atan2(v.x, v.y);
            double theta1 = Math.atan2(this.x, this.y);
            angle = new Angle(theta0 - theta1);
        }
        return angle;
    }

    public boolean isParallelTo(Vector2 v, double eps) {
        Angle a = this.getAngleMadeWith(v);
        return Math.abs(a.getRadian()) < eps;
    }

    public boolean isAntiParallelTo(Vector2 v, double eps) {
        Angle a = this.getAngleMadeWith(v);
        return Math.abs(Math.abs(a.getRadian()) - Math.PI) < eps;
    }

    public double getPerpProduct(Vector2 v) {
        return this.getX() * v.getY() - this.getY() * v.getX();
    }

    public Vector2 projectOnto(Vector2 v2) {
        Real2 unit2 = v2.getUnitVector();
        Real2 unit = this.getUnitVector();
        double dot = unit2.dotProduct(unit);
        Vector2 projection = new Vector2(unit2.multiplyBy(this.getLength() * dot));
        return projection;
    }
}

