/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.VentoFoggia;
import org.openscience.cdk.layout.IdentityTemplateLibrary;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public final class TemplateHandler {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(TemplateHandler.class);
    private final List<IAtomContainer> templates = new ArrayList<IAtomContainer>();
    private final List<Pattern> anonPatterns = new ArrayList<Pattern>();
    private final List<Pattern> elemPatterns = new ArrayList<Pattern>();
    private final AtomMatcher elemAtomMatcher = new AtomMatcher(){

        public boolean matches(IAtom a, IAtom b) {
            return a.getAtomicNumber().equals(b.getAtomicNumber());
        }
    };
    private final AtomMatcher anonAtomMatcher = new AtomMatcher(){

        public boolean matches(IAtom a, IAtom b) {
            return true;
        }
    };
    private final BondMatcher anonBondMatcher = new BondMatcher(){

        public boolean matches(IBond a, IBond b) {
            return true;
        }
    };

    public TemplateHandler(IChemObjectBuilder builder) {
        this.loadTemplates(builder);
    }

    public TemplateHandler() {
    }

    public void loadTemplates(IChemObjectBuilder builder) {
        try {
            InputStream ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/layout/templates/templates.list");
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            while (reader.ready()) {
                String line = reader.readLine();
                line = "org/openscience/cdk/layout/templates/" + line;
                LOGGER.debug((Object)"Attempting to read template ", new Object[]{line});
                try {
                    CMLReader structureReader = new CMLReader(this.getClass().getClassLoader().getResourceAsStream(line));
                    IChemFile file = (IChemFile)structureReader.read((IChemObject)((IChemFile)builder.newInstance(IChemFile.class, new Object[0])));
                    List files = ChemFileManipulator.getAllAtomContainers((IChemFile)file);
                    for (IAtomContainer container : files) {
                        this.addMolecule(container);
                    }
                    LOGGER.debug((Object)"Successfully read template ", new Object[]{line});
                }
                catch (IllegalArgumentException | CDKException e) {
                    LOGGER.warn((Object)"Could not read template ", new Object[]{line, ", reason: ", e.getMessage()});
                    LOGGER.debug((Object)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Could not read (all of the) templates, reason: ", new Object[]{e.getMessage()});
            LOGGER.debug((Object)e);
        }
    }

    public void addMolecule(IAtomContainer molecule) {
        if (!GeometryUtil.has2DCoordinates((IAtomContainer)molecule)) {
            throw new IllegalArgumentException("Template did not have 2D coordinates");
        }
        GeometryUtil.scaleMolecule((IAtomContainer)molecule, (double)GeometryUtil.getScaleFactor((IAtomContainer)molecule, (double)1.5));
        this.templates.add(molecule);
        this.anonPatterns.add(VentoFoggia.findSubstructure((IAtomContainer)molecule, (AtomMatcher)this.anonAtomMatcher, (BondMatcher)this.anonBondMatcher));
        this.elemPatterns.add(VentoFoggia.findSubstructure((IAtomContainer)molecule, (AtomMatcher)this.elemAtomMatcher, (BondMatcher)this.anonBondMatcher));
    }

    public IAtomContainer removeMolecule(IAtomContainer molecule) throws CDKException {
        for (int i = 0; i < this.templates.size(); ++i) {
            if (!VentoFoggia.findIdentical((IAtomContainer)this.templates.get(i), (AtomMatcher)this.anonAtomMatcher, (BondMatcher)this.anonBondMatcher).matches(molecule)) continue;
            this.elemPatterns.remove(i);
            this.anonPatterns.remove(i);
            return this.templates.remove(i);
        }
        return null;
    }

    public boolean mapTemplateExact(IAtomContainer molecule) throws CDKException {
        for (IAtomContainer template : this.templates) {
            Mappings mappings = VentoFoggia.findIdentical((IAtomContainer)template, (AtomMatcher)this.anonAtomMatcher, (BondMatcher)this.anonBondMatcher).matchAll(molecule);
            for (Map atoms : mappings.toAtomMap()) {
                for (Map.Entry e : atoms.entrySet()) {
                    ((IAtom)e.getValue()).setPoint2d(new Point2d(((IAtom)e.getKey()).getPoint2d()));
                    ((IAtom)e.getValue()).setFlag(1, true);
                }
                if (atoms.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mapTemplates(IAtomContainer molecule) throws CDKException {
        for (Pattern anonPattern : this.elemPatterns) {
            for (Map atoms : anonPattern.matchAll(molecule).toAtomMap()) {
                for (Map.Entry e : atoms.entrySet()) {
                    ((IAtom)e.getValue()).setPoint2d(new Point2d(((IAtom)e.getKey()).getPoint2d()));
                    ((IAtom)e.getValue()).setFlag(1, true);
                }
                if (atoms.isEmpty()) continue;
                return true;
            }
        }
        for (Pattern anonPattern : this.anonPatterns) {
            for (Map atoms : anonPattern.matchAll(molecule).toAtomMap()) {
                for (Map.Entry e : atoms.entrySet()) {
                    ((IAtom)e.getValue()).setPoint2d(new Point2d(((IAtom)e.getKey()).getPoint2d()));
                    ((IAtom)e.getValue()).setFlag(1, true);
                }
                if (atoms.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public int getTemplateCount() {
        return this.templates.size();
    }

    public IAtomContainer getTemplateAt(int position) {
        return this.templates.get(position);
    }

    public IAtomContainerSet getMappedSubstructures(IAtomContainer molecule) throws CDKException {
        IAtomContainerSet matchedSubstructures = (IAtomContainerSet)molecule.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        HashSet matchedChemObjs = new HashSet();
        for (Pattern anonPattern : this.anonPatterns) {
            for (Map map : anonPattern.matchAll(molecule).uniqueAtoms().toAtomBondMap()) {
                boolean overlaps = false;
                IAtomContainer matched = (IAtomContainer)molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                for (Map.Entry e : map.entrySet()) {
                    if (matchedChemObjs.contains(e.getValue())) {
                        overlaps = true;
                    }
                    if (e.getValue() instanceof IAtom) {
                        matched.addAtom((IAtom)e.getValue());
                        continue;
                    }
                    if (!(e.getValue() instanceof IBond)) continue;
                    matched.addBond((IBond)e.getValue());
                }
                if (overlaps) continue;
                matched.atoms().forEach(matchedChemObjs::add);
                matched.bonds().forEach(matchedChemObjs::add);
                matchedSubstructures.addAtomContainer(matched);
            }
        }
        return matchedSubstructures;
    }

    public static TemplateHandler createSingleton(IAtomContainer template) {
        try {
            TemplateHandler handler = new TemplateHandler();
            IAtomContainer copy = template.clone();
            handler.addMolecule(copy);
            return handler;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Could not clone molecule.");
        }
    }

    public static TemplateHandler createFromSubstructure(Pattern ptrn, Iterable<IAtomContainer> mols) {
        for (IAtomContainer mol : mols) {
            Iterator matched = ptrn.matchAll(mol).toSubstructures().iterator();
            if (!matched.hasNext()) continue;
            return TemplateHandler.createSingleton((IAtomContainer)matched.next());
        }
        throw new IllegalArgumentException("Pattern does not match any provided molecules");
    }

    public static TemplateHandler createFromSubstructure(Pattern ptrn, IAtomContainer mol) {
        Iterator matched = ptrn.matchAll(mol).toSubstructures().iterator();
        if (matched.hasNext()) {
            return TemplateHandler.createSingleton((IAtomContainer)matched.next());
        }
        throw new IllegalArgumentException("Pattern does not match any provided molecules");
    }

    IdentityTemplateLibrary toIdentityTemplateLibrary() {
        IdentityTemplateLibrary lib = IdentityTemplateLibrary.empty();
        for (IAtomContainer mol : this.templates) {
            lib.add(AtomContainerManipulator.anonymise((IAtomContainer)mol));
        }
        return lib;
    }
}

