/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;

public enum GuessingUnit {
    YEAR(TsUnit.P1Y, TsPeriod.DEFAULT_EPOCH, 2),
    HALF_YEAR(TsUnit.P6M, TsPeriod.DEFAULT_EPOCH, 6),
    QUADRI_MONTH(TsUnit.P4M, TsPeriod.DEFAULT_EPOCH, 4),
    QUARTER(TsUnit.P3M, TsPeriod.DEFAULT_EPOCH, 2),
    MONTH(TsUnit.P1M, TsPeriod.DEFAULT_EPOCH, 2),
    WEEK_MONDAY(TsUnit.P7D, TsPeriod.DEFAULT_EPOCH.plusDays(4L), 3),
    DAY(TsUnit.P1D, TsPeriod.DEFAULT_EPOCH, 2),
    HOUR(TsUnit.PT1H, TsPeriod.DEFAULT_EPOCH, 2),
    MINUTE(TsUnit.PT1M, TsPeriod.DEFAULT_EPOCH, 2),
    SECOND(TsUnit.PT1S, TsPeriod.DEFAULT_EPOCH, 2);

    private final TsUnit tsUnit;
    private final LocalDateTime reference;
    private final int minimumObsCount;

    public TsPeriod atId(long id) {
        return TsPeriod.builder().unit(this.tsUnit).epoch(this.reference).id(id).build();
    }

    public TsPeriod atDate(LocalDateTime start) {
        return TsPeriod.builder().unit(this.tsUnit).epoch(this.reference).date(start).build();
    }

    @Generated
    private GuessingUnit(TsUnit tsUnit, LocalDateTime reference, int minimumObsCount) {
        this.tsUnit = tsUnit;
        this.reference = reference;
        this.minimumObsCount = minimumObsCount;
    }

    @Generated
    public TsUnit getTsUnit() {
        return this.tsUnit;
    }

    @Generated
    public LocalDateTime getReference() {
        return this.reference;
    }

    @Generated
    public int getMinimumObsCount() {
        return this.minimumObsCount;
    }
}

