/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdplus.toolkit.base.api.information.BasicInformationExtractors;
import jdplus.toolkit.base.api.util.WildCards;
import lombok.NonNull;

public interface BasicInformationExtractor<S> {
    public static final char SEP = '.';
    public static final String STRSEP = new String(new char[]{'.'});

    public static boolean isDummy(String s) {
        return s == null || s.length() == 0;
    }

    public static String concatenate(String ... s) {
        switch (s.length) {
            case 0: {
                return "";
            }
            case 1: {
                return s[0];
            }
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (BasicInformationExtractor.isDummy(s[i])) continue;
            if (!first) {
                builder.append('.');
            } else {
                first = false;
            }
            builder.append(s[i]);
        }
        return builder.toString();
    }

    public static String[] prefix(@NonNull String[] str, @NonNull String prefix) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (prefix.isEmpty()) {
            return str;
        }
        String[] rslt = new String[str.length];
        for (int i = 0; i < rslt.length; ++i) {
            StringBuilder builder = new StringBuilder();
            builder.append(prefix).append('.').append(str[i]);
            rslt[i] = builder.toString();
        }
        return rslt;
    }

    public void fillDictionary(String var1, Map<String, Class> var2, boolean var3);

    public boolean contains(String var1);

    public <T> T getData(S var1, String var2, Class<T> var3);

    default public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        this.fillDictionary(null, dic, false);
        dic.forEach((key, cl) -> {
            Object obj;
            if (tclass.isAssignableFrom((Class<?>)cl) && wc.match((String)key) && (obj = this.getData(source, (String)key, tclass)) != null) {
                map.put((String)key, obj);
            }
        });
    }

    public static <S, Q> BasicInformationExtractor<S> extractor(String name, Class<Q> targetClass, Function<S, Q> fn) {
        return new BasicInformationExtractors.AtomicExtractor<S>(name, targetClass, fn);
    }

    public static <S, Q> BasicInformationExtractor<S> delegate(String name, Class<Q> target, Function<S, Q> fn) {
        return new BasicInformationExtractors.ExtractorDelegate<S, Q>(name, target, fn);
    }

    public static <S, Q> BasicInformationExtractor<S> delegateArray(String name, int start, int end, Class<Q> target, BiFunction<S, Integer, Q> fn) {
        return new BasicInformationExtractors.ArrayExtractorDelegate<S, Q>(name, start, end, target, fn);
    }

    public static <S, Q> BasicInformationExtractor<S> array(String name, int start, int end, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        return new BasicInformationExtractors.ArrayExtractor<S>(name, start, end, targetClass, fn);
    }

    public static <S, Q> BasicInformationExtractor<S> array(String name, int defparam, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        return new BasicInformationExtractors.ArrayExtractor<S>(name, defparam, defparam, targetClass, fn);
    }
}

