/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ar;

import internal.toolkit.base.core.ar.BurgAlgorithm;
import internal.toolkit.base.core.ar.LevinsonAlgorithm;
import internal.toolkit.base.core.ar.OlsAlgorithm;
import jdplus.toolkit.base.api.data.DoubleSeq;

public interface AutoRegressiveEstimation {
    public static AutoRegressiveEstimation levinson() {
        return new LevinsonAlgorithm();
    }

    public static AutoRegressiveEstimation ols() {
        return new OlsAlgorithm();
    }

    public static AutoRegressiveEstimation burg() {
        return new BurgAlgorithm();
    }

    public boolean estimate(DoubleSeq var1, int var2);

    public DoubleSeq data();

    public DoubleSeq coefficients();

    default public DoubleSeq residuals() {
        double[] e = this.data().toArray();
        double[] a = this.coefficients().toArray();
        for (int i = e.length - 1; i >= 0; --i) {
            int jmax = a.length > i ? i : a.length;
            for (int j = 1; j <= jmax; ++j) {
                int n = i;
                e[n] = e[n] - a[j - 1] * e[i - j];
            }
        }
        return DoubleSeq.of((double[])e);
    }
}

