/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import java.util.Iterator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.decomposition.GivensRotation;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderReflection;
import jdplus.toolkit.base.core.math.matrices.decomposition.IVectorTransformation;
import lombok.Generated;

public final class ElementaryTransformations {
    public static void transform(IVectorTransformation transformation, Iterator<DataBlock> vectors) {
        while (vectors.hasNext()) {
            transformation.transform(vectors.next());
        }
    }

    public static void rowHouseholder(FastMatrix m) {
        ElementaryTransformations.householder(m.rowsIterator());
    }

    public static void rowHouseholder(DataBlock row, FastMatrix X) {
        HouseholderReflection reflection = HouseholderReflection.of(row, true);
        DataBlockIterator rows = X.rowsIterator();
        while (rows.hasNext()) {
            reflection.transform(rows.next());
        }
    }

    public static boolean givensTriangularize(FastMatrix X) {
        try {
            int r = X.getRowsCount();
            int c = X.getColumnsCount();
            FastMatrix L = X;
            do {
                ElementaryTransformations.rowGivens(L);
            } while (!(L = L.extract(1, --r, 1, --c)).isEmpty());
            return true;
        }
        catch (MatrixException err) {
            return false;
        }
    }

    public static boolean fastRowGivens(DataBlock row, FastMatrix X) {
        try {
            int nr = X.getRowsCount();
            int cinc = X.getColumnIncrement();
            int beg = X.getStartPosition();
            double[] x = X.getStorage();
            double[] z = row.getStorage();
            int zbeg = row.getStartPosition();
            int zend = row.getEndPosition();
            int zinc = row.getIncrement();
            int zcur = zbeg + zinc;
            int mbeg = beg + cinc;
            while (zcur != zend) {
                double a = z[zbeg];
                double b = z[zcur];
                if (b != 0.0) {
                    double d;
                    double ro;
                    double h;
                    if (a != 0.0) {
                        h = ElementaryTransformations.hypotenuse(a, b);
                        ro = b / h;
                        d = a / h;
                    } else if (b < 0.0) {
                        d = 0.0;
                        ro = -1.0;
                        h = -b;
                    } else {
                        d = 0.0;
                        ro = 1.0;
                        h = b;
                    }
                    z[zcur] = 0.0;
                    z[zbeg] = a = h;
                    int r = 0;
                    int rdiag = beg;
                    int rcur = mbeg;
                    while (r < nr) {
                        a = x[rdiag];
                        b = x[rcur];
                        x[rdiag] = d * a + ro * b;
                        x[rcur] = -ro * a + d * b;
                        ++r;
                        ++rdiag;
                        ++rcur;
                    }
                }
                zcur += zinc;
                mbeg += cinc;
            }
            return true;
        }
        catch (MatrixException err) {
            return false;
        }
    }

    public static boolean fastGivensTriangularize(FastMatrix X) {
        try {
            int nr = X.getRowsCount();
            int nc = X.getColumnsCount();
            int cinc = X.getColumnIncrement();
            int beg = X.getStartPosition();
            int dinc = 1 + cinc;
            double[] x = X.getStorage();
            int r = 0;
            int idiag = beg;
            while (r < nr) {
                int c = r + 1;
                int cur = idiag + cinc;
                while (c < nc) {
                    double a = x[idiag];
                    double b = x[cur];
                    if (b != 0.0) {
                        double d;
                        double ro;
                        double h;
                        if (a != 0.0) {
                            h = ElementaryTransformations.hypotenuse(a, b);
                            ro = b / h;
                            d = a / h;
                        } else if (b < 0.0) {
                            d = 0.0;
                            ro = -1.0;
                            h = -b;
                        } else {
                            d = 0.0;
                            ro = 1.0;
                            h = b;
                        }
                        x[cur] = 0.0;
                        x[idiag] = a = h;
                        int s = r + 1;
                        int sdiag = idiag + 1;
                        int scur = cur + 1;
                        while (s < nr) {
                            a = x[sdiag];
                            b = x[scur];
                            x[sdiag] = d * a + ro * b;
                            x[scur] = -ro * a + d * b;
                            ++s;
                            ++sdiag;
                            ++scur;
                        }
                    }
                    ++c;
                    cur += cinc;
                }
                ++r;
                idiag += dinc;
            }
            return true;
        }
        catch (MatrixException err) {
            return false;
        }
    }

    public static boolean householderTriangularize(FastMatrix X) {
        try {
            int r = X.getRowsCount();
            int c = X.getColumnsCount();
            FastMatrix L = X;
            do {
                ElementaryTransformations.rowHouseholder(L);
            } while (!(L = L.extract(1, --r, 1, --c)).isEmpty());
            return true;
        }
        catch (MatrixException err) {
            return false;
        }
    }

    public static void rowGivens(FastMatrix m) {
        ElementaryTransformations.givens(m.rowsIterator(), m.getColumnsCount());
    }

    public static void columnHouseholder(FastMatrix m) {
        ElementaryTransformations.householder(m.columnsIterator());
    }

    public static void columnGivens(FastMatrix m) {
        ElementaryTransformations.givens(m.columnsIterator(), m.getRowsCount());
    }

    public static double hypotenuse(double x, double y) {
        double xabs = Math.abs(x);
        double yabs = Math.abs(y);
        double w = Math.max(xabs, yabs);
        double z = Math.min(xabs, yabs);
        if (z == 0.0) {
            return w;
        }
        double zw = z / w;
        return w * Math.sqrt(1.0 + zw * zw);
    }

    public static double jhypotenuse(double x, double y) {
        return Math.sqrt((x + y) * (x - y));
    }

    private static void householder(DataBlockIterator vectors) {
        HouseholderReflection reflection = HouseholderReflection.of(vectors.next(), true);
        while (vectors.hasNext()) {
            reflection.transform(vectors.next());
        }
    }

    private static void givens(DataBlockIterator vectors, int n) {
        for (int i = 1; i < n; ++i) {
            vectors.reset();
            DataBlock cur = vectors.next();
            if (cur.get(i) == 0.0) continue;
            GivensRotation rotation = GivensRotation.of(cur, i);
            while (vectors.hasNext()) {
                rotation.transform(vectors.next());
            }
        }
    }

    @Generated
    private ElementaryTransformations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

