/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.ISsfState;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.ISsfMeasurement;

public interface ISsf
extends ISsfState {
    public ISsfMeasurement measurement();

    @Override
    default public boolean isTimeInvariant() {
        return this.dynamics().isTimeInvariant() && this.measurement().isTimeInvariant();
    }

    default public ISsfLoading loading() {
        return this.measurement().loading();
    }

    default public ISsfError measurementError() {
        return this.measurement().error();
    }

    default public void xL(int pos, DataBlock x, DataBlock m, double f) {
        this.dynamics().XT(pos, x);
        this.loading().XpZd(pos, x, -x.dot(m) / f);
    }

    default public void XL(int pos, FastMatrix X, DataBlock m, double f) {
        ISsfDynamics dynamics = this.dynamics();
        ISsfLoading loading = this.loading();
        DataBlockIterator rows = X.rowsIterator();
        while (rows.hasNext()) {
            DataBlock row = rows.next();
            dynamics.XT(pos, row);
            loading.XpZd(pos, row, -row.dot(m) / f);
        }
    }

    default public void XtL(int pos, FastMatrix X, DataBlock m, double f) {
        ISsfDynamics dynamics = this.dynamics();
        ISsfLoading loading = this.loading();
        DataBlockIterator cols = X.columnsIterator();
        while (cols.hasNext()) {
            DataBlock col = cols.next();
            dynamics.XT(pos, col);
            loading.XpZd(pos, col, -col.dot(m) / f);
        }
    }

    default public void Lx(int pos, DataBlock x, DataBlock m, double f) {
        x.addAY(-this.loading().ZX(pos, x) / f, m);
        this.dynamics().TX(pos, x);
    }

    default public void LX(int pos, FastMatrix X, DataBlock m, double f) {
        ISsfDynamics dynamics = this.dynamics();
        ISsfLoading loading = this.loading();
        X.columns().forEach(col -> {
            col.addAY(-loading.ZX(pos, (DataBlock)col) / f, m);
            dynamics.TX(pos, (DataBlock)col);
        });
    }

    default public boolean diffuseEffects(FastMatrix effects) {
        ISsfDynamics dynamics = this.dynamics();
        ISsfLoading loading = this.loading();
        ISsfInitialization initializer = this.initialization();
        int n = initializer.getStateDim();
        int d = initializer.getDiffuseDim();
        if (d == 0 || d != effects.getColumnsCount()) {
            return false;
        }
        FastMatrix matrix = FastMatrix.make(n, d);
        initializer.diffuseConstraints(matrix);
        DataBlockIterator rows = effects.rowsIterator();
        int pos = 0;
        loading.ZM(pos, matrix, rows.next());
        while (rows.hasNext()) {
            dynamics.TM(pos++, matrix);
            loading.ZM(pos, matrix, rows.next());
        }
        return true;
    }
}

