/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.meta.HeterogeneousEnsembleAbstract;

public class HeterogeneousEnsembleBlast
extends HeterogeneousEnsembleAbstract
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    protected boolean[][] onlineHistory;
    public IntOption windowSizeOption = new IntOption("windowSize", 'w', "The window size over which Online Performance Estimation is done.", 1000, 1, Integer.MAX_VALUE);

    @Override
    public void resetLearningImpl() {
        this.historyTotal = new double[this.ensemble.length];
        this.onlineHistory = new boolean[this.ensemble.length][this.windowSizeOption.getValue()];
        this.instancesSeen = 0;
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i].resetLearning();
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        int wValue = this.windowSizeOption.getValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            boolean correct;
            double[] votes = this.ensemble[i].getVotesForInstance(inst);
            boolean bl = correct = (double)HeterogeneousEnsembleBlast.maxIndex(votes) * 1.0 == inst.classValue();
            if (correct && !this.onlineHistory[i][this.instancesSeen % wValue]) {
                this.onlineHistory[i][this.instancesSeen.intValue() % wValue] = true;
                int n = i;
                this.historyTotal[n] = this.historyTotal[n] + 1.0 / (double)wValue;
            } else if (!correct && this.onlineHistory[i][this.instancesSeen % wValue]) {
                this.onlineHistory[i][this.instancesSeen.intValue() % wValue] = false;
                int n = i;
                this.historyTotal[n] = this.historyTotal[n] - 1.0 / (double)wValue;
            }
            this.ensemble[i].trainOnInstance(inst);
        }
        this.instancesSeen = this.instancesSeen + 1;
        if (this.instancesSeen % this.gracePerionOption.getValue() == 0) {
            this.topK = HeterogeneousEnsembleBlast.topK(this.historyTotal, this.activeClassifiersOption.getValue());
        }
    }
}

