#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Akademia Ekonomiczna we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Statystyczna analiza wielowymiarowa z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# totalutilities(xfrm, y, x, n, p, S) - funkcja obliczajca macierz uytecznoci cakowitych
# profilw w przekroju respondentw Usi[S, n]
# xfrm - wyraenie reprezentujce w modelu atrybuty
# y - wektor preferencji empirycznych y[n*S]
# x - macierz reprezentujca profile
# n - liczba profilw
# S - liczba respondentw
# p - liczba poziomw wszystkich atrybutw z wyrazem wolnym (bez poziomw odniesienia),
# liczba zmiennych sztucznych plus wyraz wolny
# wywoanie - Usi <- totalutilities(xfrm, y, x, n, p, S)

totalutilities <- function(xfrm, y, x, n, p, S)
{
   Usi <- matrix(0, S, n)   #macierz uytecznoci cakowitych profilw w przekroju respondentw
   Y <- vector("numeric", n)
   Ys <- as.data.frame(Y)   #preferencje empiryczne s-tego respondenta
   for(s in 0:(S-1))
   {
      k <- n*s+1            #indeks wskazujcy wektor preferencji s-tego respondenta
      for (i in 1:n)
      {
         Ys[i,1] <- y[k,1]
         k <- k+1
      }
      frml <- as.formula(paste("Ys$Y~", paste(xfrm)))
      camodel <- lm(frml)
      u <- as.matrix(camodel$coeff)   #uytecznoci czstkowe poziomw atrybutw s-tego respondenta
      Z <- model.matrix(camodel)      #macierz ukadu czynnikowego ze zmiennymi sztucznymi
      U <- Z%*%u                      #uytecznoci cakowite profilw dla s-tego respondenta
      for(i in 1:n) {Usi[(s+1),i] <- U[i]}
   }
   return(Usi)
}