#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Joanna i Micha Trzsiok     Akademia Ekonomiczna w Katowicach
#*  
#*  Przykad do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# Uwaga - przeprowadzenie poniszej procedury w znacznym stopniu obcia procesor oraz pami komputera - oczekiwanie na wyniki moe trwa kilkanacie minut
library(gbm)
library(MASS)
data(Boston)
options(OutDec=",")
# Losowy podzia zbioru uczcego na 5 czci i obliczenie bdu redniokwadratowego metod sprawdzania krzyowego 
MSE.cv <- c()
set.seed(111)   # Ustawienie generatora liczb losowych
wekt.losowy <- sample(1:nrow(Boston), nrow(Boston))
for (i in 1:5){
  indeks.walidac <- wekt.losowy[(floor((i-1)*length(wekt.losowy)/5)+1):floor(i*length(wekt.losowy)/5)]
  cv.walidac <- Boston[indeks.walidac,]
  cv.uczacy <- Boston[-indeks.walidac,]
  modelGBM <- gbm(medv ~ ., distribution="gaussian", data=cv.uczacy, n.trees=10000, cv.folds=5, interaction.depth=3, verbose=FALSE)
  getOption("device")()
  l.drzew <- gbm.perf(modelGBM, method="cv")
  walidac.bez.y <- subset(cv.walidac, select=-medv) 
  y.teoret <- predict(modelGBM, walidac.bez.y, n.trees=l.drzew) 
  MSE <- sum((cv.walidac$medv-y.teoret)^2)/length(y.teoret)
  MSE.cv <- c(MSE.cv,MSE)
  MSE <- NULL 
}
print(paste("Bd redniokwadratowy modelu MART:", round(mean(MSE.cv), digits=3)), quote=FALSE)
print("Charakterystyki modelu zbudowanego na caym zbiorze uczcym:", quote=FALSE)
modelGBM <- gbm(medv ~ ., distribution="gaussian", data=Boston, n.trees=10000, cv.folds=5, interaction.depth=3, verbose=FALSE)
getOption("device")()
l.drzew <- gbm.perf(modelGBM, method="cv")
modelGBM <- gbm(medv ~ ., distribution="gaussian", data=Boston, n.trees=l.drzew, cv.folds=5, interaction.depth=3, verbose=FALSE)
print(paste("Liczba funkcji skadowych (drzew) w modelu:", l.drzew), quote=FALSE) 
print(summary(modelGBM))