/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.Filter;

public class JBIG2Filter
implements Filter {
    private static final Log LOG = LogFactory.getLog(JBIG2Filter.class);

    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JBIG2");
        if (!readers.hasNext()) {
            LOG.error((Object)"Can't find an ImageIO plugin to decode the JBIG2 encoded datastream.");
            return;
        }
        ImageReader reader = readers.next();
        if (reader == null) {
            LOG.error((Object)"ImageIO plugin to decode the JBIG2 encoded datastream is null.");
            return;
        }
        COSBase decodeP = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary decodeParms = null;
        if (decodeP instanceof COSDictionary) {
            decodeParms = (COSDictionary)decodeP;
        } else if (decodeP instanceof COSArray) {
            decodeParms = (COSDictionary)((COSArray)decodeP).getObject(filterIndex);
        }
        int bits = options.getInt(COSName.BITS_PER_COMPONENT, 1);
        COSStream st = null;
        if (decodeParms != null) {
            st = (COSStream)decodeParms.getDictionaryObject(COSName.JBIG2_GLOBALS);
        }
        if (st != null) {
            compressedData = new SequenceInputStream(st.getUnfilteredStream(), compressedData);
        }
        ImageInputStream iis = ImageIO.createImageInputStream(compressedData);
        reader.setInput(iis);
        BufferedImage bi = reader.read(0, reader.getDefaultReadParam());
        iis.close();
        reader.dispose();
        if (bi != null) {
            DataBuffer dBuf;
            if (bi.getColorModel().getPixelSize() != bits) {
                if (bits != 1) {
                    LOG.error((Object)"Do not know how to deal with JBIG2 with more than 1 bit");
                    return;
                }
                BufferedImage packedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 12);
                Graphics graphics = packedImage.getGraphics();
                graphics.drawImage(bi, 0, 0, null);
                graphics.dispose();
                bi = packedImage;
            }
            if ((dBuf = bi.getData().getDataBuffer()).getDataType() == 0) {
                result.write(((DataBufferByte)dBuf).getData());
            } else {
                LOG.error((Object)("Image data buffer not of type byte but type " + dBuf.getDataType()));
            }
        } else {
            LOG.error((Object)"Something went wrong when decoding the JBIG2 encoded datastream.");
        }
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        System.err.println("Warning: JBIG2.encode is not implemented yet, skipping this stream.");
    }
}

