
# ================================================================================
# Marks for front window.
#================================================================================

proc namedMarkProc {menu item} {
    switch -- $item {
	"markFile"			{markFile; message "File marked."}
	"set" 				{setNamedMark}
	"goto"				{gotoFileMark}
	"remove"			{removeNamedMark}
	"sort"				{sortMarksFile}
	"sortByPosition"	{orderMarks}
    }
}

proc unnamedMarkproc {menu item} {
    switch -- $item {
	"set" 					{setMark}
	"exchangePointAndMark"	{exchangePointAndMark}
	"hilite"				{markHilite}
    }
}
	


proc gotoFileMark {} {
    set text [getSelect]
    if {[string length $text] && ([string length $text] < 20)} {
	gotoMark [listpick -p "Mark?" -L [list $text] [getNamedMarks -n]]
    } else {
	gotoMark [listpick -p "Mark?" [getNamedMarks -n]]
    }
}

proc markFile {} {
    if {[llength [getNamedMarks -n]]} {
	global quietlyClearMarks
	if {$quietlyClearMarks || [dialog::yesno -c "Clear old marks?"]} {
	    clearFileMarks
	}
    }
    global mode
    mode::proc MarkFile
}

proc ::MarkFile {} {
    message "This mode does not support file marking."
}

proc removeAllMarks {{pat *}} {
    set win [win::Current]
    if {![catch {
	foreach mk [getNamedMarks -n] {
	    if {[string match $pat $mk]} {
		removeNamedMark -n $mk -w $win
	    }
	} } ] } { 
	return 
    }
    # some marks contain curly braces!
    foreach mk [quote::Regfind [getNamedMarks -n]] {
	if {[string match $pat $mk]} {
	    removeNamedMark -n $mk -w $win
	}
	if {[string index $mk 0] == "\{"} {
	    set mk [string range $mk 1 [expr {[string length $mk] -1}]]
	}
	if {[string match $pat $mk]} {
	    removeNamedMark -n $mk -w $win
	}
    }
}

proc clearFileMarks {} {removeAllMarks}

proc sortMarksFile {} {
    if {![dialog::yesno "Really sort all marks?"]} {return}
    
    set nm [win::Current]
    
    set mks {}
    foreach mk [getNamedMarks] {
	removeNamedMark -n [lindex $mk 0] -w [lindex $mk 1]
	lappend mks $mk
    }
    
    foreach mk [lsort $mks] {
	set name [lindex $mk 0]
	set disp [lindex $mk 2]
	set pos [lindex $mk 3]
	set end [lindex $mk 4]
	
	setNamedMark $name $disp $pos $end
    }
}

# From Mark Nagata
proc zeroadd {num} {
    set mx [maxPos]
    set len [string length $mx]
    set num [format "%0${len}d" $num]
    return $num
}

proc orderMarks {} {
    if {![dialog::yesno "Really reorder all marks?"]} {return}
    
    set nm [win::Current]
    
    set wks {}
    foreach mk [getNamedMarks] {
	removeNamedMark -n [lindex $mk 0] -w $nm
	set name [lindex $mk 0]
	set disp [lindex $mk 2]
	set pos [lindex $mk 3]
	set end [lindex $mk 4]
	set pos [zeroadd $pos]
	set wk [list $pos $disp $name $end]
	lappend wks $wk
    }
    
    foreach wk [lsort $wks] {
	set name [lindex $wk 2]
	set disp [lindex $wk 1]
	set pos [lindex $wk 0]
	set end [lindex $wk 3]
	
	setNamedMark $name $disp $pos $end
    }
}


# ================================================================================
# Simple mark stack implementation
# ================================================================================

proc placeBookmark {{msg 1}} {
    global markStack
    global markName
    
    set name mark$markName
    incr markName
    createTMark $name [getPos]
    set fileName [win::Current]
    set markStack [linsert $markStack 0 [list $fileName $name]]
    if {$msg} {
	message "Placed bookmark \#[llength $markStack]"
    }
}

proc returnToBookmark {{msg 1}} {
    global markStack
    if {[llength $markStack] == "0"} {
	message "No bookmarks have been placed!"
	return
    }
    set mark [lindex [lindex $markStack 0] 1]
    set markStack [lreplace $markStack 0 0]
    if {[catch {gotoTMark $mark}]} {
	returnToBookmark
	return
    }
    if {$msg} {
	message "Returned to bookmark \#[expr {[llength $markStack] + 1}]"
    }
}

# Used to create a popup of all funcs in window. Routine 
# should return list containing, consecutively, proc name and
# start of definition. 
proc parseFuncsAlpha {} {
    mode::proc parseFuncs
}

proc ::parseFuncs {} {
    global sortFuncsMenu funcExpr parseExpr
    
    set pos [minPos]
    set m {}
    if {$sortFuncsMenu} {
	while {[set res [search -s -f 1 -r 1 -i 0 -n $funcExpr $pos]] != ""} {
	    if {[regexp -- $parseExpr [eval getText $res] dummy word]} {
		lappend m [list $word [lindex $res 0]]
	    }
	    set pos [lindex $res 1]
	}
	regsub -all "\[\{\}\]" [lsort -ignore $m] "" m
    } else {
	while {[set res [search -s -f 1 -r 1 -i 0 -n $funcExpr $pos]] != ""} {
	    if {[regexp -- $parseExpr [eval getText $res] dummy word]} {
		lappend m $word [lindex $res 0]
	    }
	    set pos [lindex $res 1]
	}
    }
    return $m
}

proc gotoFunc {} {
    set l [parseFuncsAlpha]
    if {[set ind [lsearch $l {(-}]] >= 0} {
	set l [lrange $l [expr {$ind + 2}] end]
    }
    
    while {[llength $l] > 1} {
	lappend names [lindex $l 0]
	lappend positions [lindex $l 1]
	set l [lrange $l 2 end]
    }
    
    set res [listpick -p "Func:" $names]
    if {[set ind [lsearch $names $res]] >= 0} {
	goto [lindex $positions $ind]
    }
}


proc editMark {fname mname args} {
    if {[set pos [lsearch [winNames -f] "*$fname*"]] >= 0}  {
    	bringToFront [lindex [winNames -f] $pos]
	if {[icon -q]} {
	    icon -o
	} 
    } else {
    	if {[lsearch $args {-r}] >= 0} {
	    edit -r "$fname"
    	} else {
	    edit "$fname"
	}
    }
    set mNames [getNamedMarks -n]
    if {[set closestFound [lsearch -glob $mNames "*${mname}*"]] < 0} {
	catch {mode::proc MarkFile}
	set mNames [getNamedMarks -n]
    } 
    if {[lsearch $mNames "${mname}"] >= 0} {
    	gotoMark $mname
    } elseif {[lsearch $mNames " ${mname}"] >= 0} {
	#this gets used when procName is indented in pop-up -tr
    	gotoMark " $mname"
    } else {
	if {$closestFound == -1} {
	    return 1
	} else {
	    gotoMark [lindex $mNames $closestFound]
	}
	
    }
    return 0
}






