/*
 * SOURCE:  intui.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *          03/17/1992 - default gadget types
 *
 * (c)M.Schollmeyer
 */
#ifndef INTUI_H
#define INTUI_H

#ifndef MACROS_H
#include "macros.h"
#endif

#ifndef DOS_H
#include "dos.h"
#endif

#ifndef BIOS_H
#include "bios.h"
#endif

#ifndef VIDEO_H
#include "video.h"
#endif

#ifndef SETTING_H
#include "setting.h"
#endif

#ifndef MEMORY_H
#include "memory.h"
#endif

#ifndef PROFILE_H
#include "profile.h"
#endif


#define DOUBLE_BORDER 0x00000001L

struct Border {
    struct Border *Next;      /* Link to next structure, HNULL if none */
    char *Title;
    int Left, Top;            /* left and top offset */
    int Width, Height;        /* width and height of border */
    unsigned long Flags;
};

    // flags for IntuiText.Flags
#define IT_LEFT      (1<<0)
#define IT_RIGHT     (1<<1)
#define IT_CENTER    (1<<2)
#define IT_MULTILINE (1<<3)
#define IT_VERTICAL  (1<<4)
#define IT_SELECTED  (1<<5)    /* set if requester string has been selected */
#define IT_HILITE    (1<<6)
#define IT_ITALIC    (1<<7)

struct IntuiText {
    struct IntuiText *Next;    /* Link to Next structure, HNULL if none */
    struct Border *TextBorder; /* Link to Border Structure, HNULL if none */
    char *Text;                /* Pointer to text string */
    int Left, Top;             /* Left and top offset of text */
    int Width;
    unsigned int Flags;
};

#define STATIC_WINDOW 1L      /* if your window is static, Window->Buffer */
                              /* must point to a screen save buffer       */
#define SHADOWLESS    2L

struct Window {
    int NewLeft, NewTop;      /* left and top offset */
    int Width, Height;        /* width and height of window */
    int Left, Top;            /* Initialized by INTUITION */
    char *Title;              /* title printed in first line, NULL if none */
    unsigned long Flags;      /* window flags s.a. */
    void *Buffer;             /* buffer to backup screen frame */
};

                                       /* Gadget types : */
#define TEXTGADGET          0x00000001L /* Display a text gadget */
#define LONGINT             0x00000002L /* for use with TEXTGADGET */
#define BOOLGADGET          0x00000004L /* display a boolean gadget */
#define REQGADGET           0x00000008L /* a request gadget */
#define POPGADGET           0x00000010L
#define CHECKGADGET         0x00000020L /* display a checkmark gadget */
#define OPTIONGADGET        0x00000040L /* option gadget */
#define DEFOKGADGET         0x00000080L /* default gadget types */
#define DEFCANCELGADGET     0x00000100L
#define DEFHELPGADGET       0x00000200L
#define CUSTOMGADGET        0x00000400L /* customized gadget */

#define _GADGETTYPES (TEXTGADGET|LONGINT|BOOLGADGET|REQGADGET\
|CHECKGADGET|OPTIONGADGET)

#define BORDERLESS          0x00000800L /* Display gadget without border */

#define NODESELECT          0x00001000L /* This gadget cannot be deselected */
#define SELECTED            0x00002000L /* this gadget is selected */
#define ENDGADGET           0x00004000L /* returns control by selecting this gadget */
#define TOGGLESELECT        0x00008000L /* this gadget toggles selected/not selected */
#define ACTIVATED           0x00010000L /* this is the first current gadget
                                           never set this bit on two gadgets */
#define DISABLED            0x00020000L /* This gadget is DISABLED */
#define SINGLESELECT        0x00040000L /* This REQGADGET can be selected by
                                           single clicking on items */
#define DOEXPAND            0x00080000L /* This TEXTGADGET can be expanded
                                           by pressing F4 */
#define MARKEND             0x00100000L /* This TEXTGADGET will mark end of */
                                        /*  string                          */
#define HOTKEYNOSELECT      0x00200000L /* This gadget is not selected when */
                                        /* activated with the hot key       */
#define LEFTBORDER          0x80000000L /* make gadget part of window border */
#define RIGHTBORDER         0x20000000L
#define TOPBORDER           0x10000000L
#define BOTTOMBORDER        0x40000000L

        /* flags passed to handler routine of CUSTOMGADGET */
#define CG_INITIALIZE   0x00000001L /* send to custom gadget while initializing */
#define CG_REDRAW       0x00000002L /* send to custom gadget if should be
                                       redrawed */
#define CG_ACTIVATED    0x00000004L /* send to custom gadget if gadget has
                                       been activated */
#define CG_CHANGE       0x00000008L /* send to custom gadget if any other
                                       gadget changed values */
#define CG_F4           0x00000010L /* send to custom gadget if F4 pressed */
                                    /* (expand gadget of other user command) */
#define CG_OWNREDRAW    0x00000020L /* send to OWNREDRAW requester */

    // arrow style (used internally)
#define _GADARRUP   24
#define _GADARRDOWN 25

struct Gadget {
    struct Gadget *Next;        /* link to next structure */
    struct IntuiText *IText;    /* link to IntuiText */
    int Left;                   /* left offset */
    int Top;                    /* top offset */
    int Width;                  /* width of gadget */
    int Height;                 /* height of gadget */
    unsigned long Flags;        /* flags s.o. */
    APTR SpecialInfo;
    unsigned long MutalExclude; /* this value is used to automatically
                                 * delselect another TOGGLESELECT BOOLGADGET
                                 * when selecting this gadget.
                                 * gadgets with the same MutalExclude value
                                 * will never be selected at once
                                 */
};


                // flags for Request->Flags
#define MULTISELECT   (1L<<1)
#define RESETREQUEST  (1L<<2)      // set this bit to reset multiselected
                                   // items on entry
#define ISMULTISEL    (1L<<3)      // set by Intuition if multiple selection
#define NOBARHILITE   (1L<<4)      // don't hilite current item
#define OWNREDRAW     (1L<<5)      // Will not be refreshed by INTUITION

                /* return values (RetVal) */
#define RETURNCANCEL   -1
#define RETURNPENDING   0
#define RETURNKEY       1
#define RETURNMOUSE     2

struct Request {
    struct IntuiText *Title;
    struct IntuiText **Items;   /* List of items, terminated by NULL pointer */
    unsigned long Flags;
    int RetVal;
    int CurrIt;
    struct Gadget *TextLink;    /* Contains pointer to text gadget if
                                   LINKEDREQUEST is set */
    int WinTop;
    int NumIt;
};

struct StringInfo {
    char *Buffer;
    int MaxChars;
    long LongInt;               /* buffer for LONGINT gadget */
};

    /* flags for DrawMenuTitle() */
#define MENU_DISABLE 1L
    /* flags for MenuItem->Flags */
#define ITEM_DISABLE 1L
#define ITEM_SECTION 2L

#define MAX_MENUWIDTH  20       /* change one of these if your menu */
#define MAX_MENUHEIGHT 25       /* is larger.                       */
#define MENUHOTINTRODUCER   '&'

    /* the long value returned by CheckMenu() can be used to get the
       selected menu:

       1111111111111111
       
                Menu number (1...31)
           MenuItem number (1...63)
        SubItem number (1...31)
        Accelerator selection
     */

#define MENUNULL 0L
#define MENUCANCEL -1L
#define MENUNUM(n) ( (n) & 0x1f )
#define ITEMNUM(n) ( ( (n) >>  5 ) & 0x3f )
#define SUBNUM(n)  ( ( (n) >> 11 ) & 0x0f )
#define ACCELERATOR(n) ( (n) & 0x8000 )

    /* The following macros are used by INTUITION to evulate
       the return code of CheckMenu()
     */
#define SHIFTMENU(n) ( (n) & 0x1f )
#define SHIFTITEM(n) ( ( (n) & 0x3f ) <<  5 )
#define SHIFTSUB(n)  ( ( (n) & 0x1f ) << 11 )
#define ACCELERATORBIT 0x8000

struct Menu {
    struct Menu *Next;          /* link to next Menu */
    struct MenuItem *First;     /* link to first MenuItem */
    char *MenuName;             /* link to name of menu */
    int Top;                    /* the following is filled in by INTUITION */
    int Width;
    int Height;
    struct Window *Window;
    int buffer[2];
};

struct MenuItem {
    struct MenuItem *Next;      /* link to next MenuItem */
    char *ItemName;             /* link to name of Item */
    char *Message;
    int HlpIndex;
    unsigned int ShortKey;
    unsigned long Flags;        /* flags for MenuItem */
    int Top;                    /* filled in by INTUITION, top offset */
};

    /* flags passed to MenuHandler routine */
#define MH_OPENMENU    (1L<<0)
#define MH_CHECKITEM   (1L<<1)
#define MH_DESTROYMENU (1L<<2)

        /* flags for DoMessageBox() */
#define DMB_OK      (1<<0)
#define DMB_YES     (1<<1)
#define DMB_NO      (1<<2)
#define DMB_RETRY   (1<<3)
#define DMB_CANCEL  (1<<4)

#define DMB_BEEP    (1<<5)
#define DMB_STATIC  (1<<6)

struct IntuitionBase {
    struct InputEvent *InputEvent;
    unsigned int MouseStatus;
    unsigned int VideoBase;
    colorreg GadgetColor;
    colorreg GadgetSelect;
    colorreg GadgetHot;
    colorreg GadgetHotSelect;
    colorreg WindowColor;
    colorreg BorderColor;
    colorreg TextColor;
    int SoundFreq;
    int SoundDur;

};

#define lpszWarning "Warning"

                    /* function prototypes */
struct IntuitionBase *OpenIntuition( int );
                        /* Version */
void DrawBorder( struct Border * , int, int );
                        /* border, left offset, top offset */
void CenterText( struct IntuiText *, int );

int PrintIText( struct IntuiText * , int, int );
                        /* itext, left offset, top offset */
void ClearScreen( void );
                        /* no arguments required */
int OpenWindow( struct Window *, int );
                        /* window structure, help topic */
int RefreshWindow( struct Window * );

extern void CloseWindow( struct Window * );
                        /* no arguments required */
struct Gadget *OpenGadget( struct Gadget *, int, int, struct Gadget *(*)() );
                        /* first gadget, left offset, top offset, handler */
void DrawGadget( struct Gadget *, unsigned, unsigned );
BOOL SetMSGadget( struct Request * );

struct Gadget *FindGadget( struct Gadget *, int, int );

void DrawMenuTitle( struct Menu *, unsigned int, unsigned long );

unsigned long CheckMenu( struct Menu *, struct InputEvent *, void (*)() );
                        /* open a menu, returns qualifier of choice */
void Beep( void );

void DoErrorBox( int, char *, ... );
        /* topic, format */
int DoMessageBox( int, int, char *, char *, ... );
                /* flags, topic, caption, format, ... */
int DoYMessageBox( int, int, int, char *, char *, ... );
                /* flags, topic, windowy, caption, format, ... */
int PutError( int err, char *msg );
#define ALIGN_LEFT   0
#define ALIGN_RIGHT  1
#define ALIGN_CENTER 2

#endif
