/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/msg.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __MSG_C__

#include "common.h"

#include "global.h"
#include "msg.h"

/*----------------------------------------------------------------------------
  void MSG_fatal(PSZ szMessage)
  put out a message to stderr and exit program.
  given:   string
  returns: never

  void MSG_fatal_0(PSZ szMessage)
  put out a message to stderr but does not exit program.
*/

void MSG_fatal(PSZ szMessage)
{
    fputs(szMessage, stderr);
    fputs("Program stopped !\n", stderr);
    exit(255);
}

void MSG_fatal_0(PSZ szMessage)
{
    fputs(szMessage, stderr);
}


/*----------------------------------------------------------------------------
  void MSG_fatal_n(int msg_n)
  put out a fatal-message referenced by number.
  given:   number of message-string
  returns: never (but see below)
  Note:    The special case FAT_NOFATAL causes a simple return.
           This can be used to inhibit an fatal() message.
*/

void MSG_fatal_n(int msg_n)
{
  switch (msg_n)
    {
      case FAT_OPENCONF:  case FAT_OPENMAST:  case FAT_OPEN:
         fputs("can't open ", stderr); break;
      case FAT_READMAST:  case FAT_READCONF:  case FAT_READ:
         fputs("error reading ", stderr); break;
    }
  switch (msg_n)
    {
      case FAT_NOFATAL:     break;
      case FAT_NOMEM:       MSG_fatal("out of memory.\n");
      case FAT_OPENCONF:
      case FAT_READCONF:    MSG_fatal("configfile.\n");
      case FAT_OPENMAST:
      case FAT_READMAST:    MSG_fatal("masterfile.\n");
      case FAT_OPEN:
      case FAT_READ:        MSG_fatal("file.\n");
      case FAT_NOCURDIR:    MSG_fatal("can't get working dir.\n");
      case FAT_NOCHDIR:     MSG_fatal("can't set working dir.\n");
      default:              MSG_fatal("fatal error.\n");
    }
}


/*----------------------------------------------------------------------------
  void MSG_msg(PSZ szMessage)
  put out a message to stdout if not in silent-mode.
  given:   string
  returns: nothing
*/

void MSG_msg(PSZ szMessage)
{
   if (OPT_mode_silent) return;
   fputs(szMessage, stdout);
   fflush(stdout);
}


/*----------------------------------------------------------------------------
  void MSG_msg_n(int msg_n)
  put out a message referenced by number
  given:   number of message-string
  returns: nothing
*/

void MSG_msg_n(int msg_n)
{
  switch (msg_n)
    {
      case MSG_SECNOTFOUND: MSG_msg("section not found in configfile: ");
                            break;
      case MSG_NOCMD:       MSG_msg("no command given.\n");
                            break;
      case MSG_INVMASK:     MSG_msg("invalid mask (%) in cmd.\n");
                            break;
      case MSG_INVKEY:      MSG_msg("invalid keyword.\n");
                            break;
      case MSG_INVKEYARG:   MSG_msg("invalid keyword argument.\n");
                            break;
      case MSG_KEYTWICE:    MSG_msg("keyword found twice or more.\n");
                            break;
      case MSG_CALLSYS:     MSG_msg("[system: ");
                            break;
      case MSG_CONFERR:     MSG_msg("your configfile has errors (ignored).\n");
                            break;
      case MSG_NOABSPATH:   MSG_msg("can't get absolute path.\n");
                            break;
      case MSG_ENTERDIR:    MSG_msg("[entering dir: ");
                            break;
      case MSG_REENTDIR:    MSG_msg("[reentering dir: ");
                            break;
      case MSG_FAILED:      MSG_msg("failed.\n");
                            break;
      case MSG_OK:          MSG_msg("ok.\n");
                            break;
      case MSG_ERRVARG:     MSG_msg("error building command.\n");
                            break;
      case MSG_RBRACE:      MSG_msg("]\n");
                            break;
 
    }
}


/*---------------------------------------------------------------------------
  void MSG_copyright(void)
  put out the copright-message to stdout if not in silent-mode.
  returns: nothing
*/

void MSG_copyright(void)
{
    if (FLAG_printed_cr) return;
    MSG_msg(SZ_Copyright);
    if (!OPT_mode_silent) FLAG_printed_cr = 1;
}


/*---------------------------------------------------------------------------
  void MSG_usage(void)
  put out the usage-message to stdout even if in silent-mode.
  then terminate program.
  returns: never
*/

void MSG_usage(void)
{
    OPT_mode_silent = 0;           /* turn of silent-mode */
    MSG_copyright();
    MSG_msg("usage: txlaunch '<sectionname>' <filename|keyword> [options]\n");
    MSG_msg("options: -c<configfile>\t : overwrite path to configfile.\n");
    MSG_msg("\t -c$<envvar>\t : overwrite path to configfile using env.-variable.\n"); 
    MSG_msg("\t -m<configfile>\t : path to masterfile.\n");
    MSG_msg("\t -m$<envvar>\t : path to masterfile using env.-variable.\n"); 
    MSG_msg("\t -k\t\t : keyword mode (instead of filename)\n");
    MSG_msg("\t -s\t\t : run silent\n");
    MSG_msg("\t -Df\t\t : show file access\n");
    MSG_msg("\t -Da\t\t : show arguments\n");

    exit(255);
}


/*------------------------------------------------------------------------ */
