/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/prf.h"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#ifndef __PRF_H__
#define __PRF_H__

typedef struct TAG_profile {
    FILE               *fp;
    PSZ                 szGivenFile;
    PSZ                 szAbsPath;   /* path to file, drvletter+dir */
    PSZ                 szFileName;  /* full path to file */
    ULONG               lineno;
    struct TAG_profile *prf_nest_upper;
  }
  PRFSTRUCT;

typedef PRFSTRUCT  *PRF;
typedef PRFSTRUCT **PPRF;

/*--------------------------------------------------------------------- */
/* exported functions */

int   PRF_open_file      (PSZ szFile, PPRF pPrf, int fatal_code);
void  PRF_close_file     (PPRF pPrf);
void  PRF_close_allfiles (PPRF pPrf);
int   PRF_readln         (PPRF pPrf, PPSZ pszLineBuf, int fatal_code);

/*--------------------------------------------------------------------- */
/* private functions */

#ifdef __PRF_C__

void  PRF_debug_file     (PSZ szMsg, PRF prf);
int   PRF_readln0        (PPRF pPrf, PPSZ pszLineBuf, int fatal_code);
int   PRF_readln1        (PPRF pPrf, PPSZ pszLineBuf, int fatal_code);

#endif

#endif  /* ifndef __PRF_H__ */


/* ------------------------------------------------------------------------ */
