procedure JoinHeader(var FParam : FontParamRec;
                     var FDim   : FontDimenRec;
                     var HFlags : FontHeadFlags;
                     fontat : float; flfontat : boolean);
var res : float;
begin

  if FParam.FontDesignSize <= 0.0 then
  begin
       ErrorLog('*** Error : New DESIGNSIZE < 0 : '
                  +ConvReal(FParam.FontDesignSize));
       ErrorLog('            DESIGNSIZE is set to 10.0');
       FParam.FontDesignSize:=10.0; FlagError:=true;
  end;
  if FParam.FontDesignUnits <= 0.0 then
  begin
       ErrorLog('*** Error : New DESIGNUNITS < 0 : '
                  +ConvReal(FParam.FontDesignUnits));
       ErrorLog('            DESIGNUNITS is set to 1.0');
       FParam.FontDesignUnits:=1.0; FlagError:=true;
  end;

  if HFlags.FlFontCheckSum and (not HFlagsGlb.FlFontCheckSum)
     then VParamGlb.FontCheckSum:=FParam.FontCheckSum;
  if HFlags.FlFontFamily   and (not HFlagsGlb.FlFontFamily)
     then VParamGlb.FontFamily  :=FParam.FontFamily;
  if HFlags.FlFontFace     and (not HFlagsGlb.FlFontFace)
     then VParamGlb.FontFace    :=FParam.FontFace;
  if HFlags.FlFontCoding   and (not HFlagsGlb.FlFontCoding)
     then VParamGlb.FontCoding  :=FParam.FontCoding;
  if HFlags.FlBoundChar    and (not HFlagsGlb.FlBoundChar)
     then
  begin
       VParamGlb.BoundChar   :=FParam.BoundChar;
       VParamGlb.FlBoundChar :=FParam.FlBoundChar;
  end;

  if HFlags.FlFontDesignUnits and (not HFlagsGlb.FlFontDesignUnits)
  then begin
       VParamGlb.FontDesignUnits:=FParam.FontDesignUnits;
  end;

  if HFlags.FlFontDesignSize and (not HFlagsGlb.FlFontDesignSize)
  then begin
       VParamGlb.FontDesignSize:=FParam.FontDesignSize;
  end;

  {--- recalculate to ligunits/ligdesignsize ---}
  res:=(FParam.FontDesignSize*LigDesignUnitsGlb)
       /(FParam.FontDesignUnits*LigDesignSizeGlb);
  if FlFontAt then
  begin
       res:=res*FontAT/FParam.FontDesignSize;
  end;

  with FDim do
  begin
       {!!! Slant !!!}
       Space:=res*FDim.Space;
       Stretch:=res*FDim.Stretch;
       Shrink:=res*FDim.Shrink;
       XHeight:=res*FDim.XHeight;
       Quad:=res*FDim.Quad;
       ExtraSpace:=res*FDim.ExtraSpace;
       Num1:=res*FDim.Num1;
       Num2:=res*FDim.Num2;
       Num3:=res*FDim.Num3;
       Denom1:=res*FDim.Denom1;
       Denom2:=res*FDim.Denom2;
       Sup1:=res*FDim.Sup1;
       Sup2:=res*FDim.Sup2;
       Sup3:=res*FDim.Sup3;
       Sub1:=res*FDim.Sub1;
       Sub2:=res*FDim.Sub2;
       SupDrop:=res*FDim.SupDrop;
       SubDrop:=res*FDim.SubDrop;
       Delim1:=res*FDim.Delim1;
       Delim2:=res*FDim.Delim2;
       AxisHeight:=res*FDim.AxisHeight;
  end;

  if HFlags.FlSlant      and (not HFlagsGlb.FlSlant)
     then FontDimenGlb.Slant      :=FDim.Slant;
  if HFlags.FlSpace      and (not HFlagsGlb.FlSpace)
     then FontDimenGlb.Space      :=FDim.Space;
  if HFlags.FlStretch    and (not HFlagsGlb.FlStretch)
     then FontDimenGlb.Stretch    :=FDim.Stretch;
  if HFlags.FlShrink     and (not HFlagsGlb.FlShrink)
     then FontDimenGlb.Shrink     :=FDim.Shrink;
  if HFlags.FlXHeight    and (not HFlagsGlb.FlXHeight)
     then FontDimenGlb.XHeight    :=FDim.XHeight;
  if HFlags.FlQuad       and (not HFlagsGlb.FlQuad)
     then FontDimenGlb.Quad       :=FDim.Quad;
  if HFlags.FlExtraSpace and (not HFlagsGlb.FlExtraSpace)
     then FontDimenGlb.ExtraSpace :=FDim.ExtraSpace;
  if HFlags.FlNum1       and (not HFlagsGlb.FlNum1)
     then FontDimenGlb.Num1       :=FDim.Num1;
  if HFlags.FlNum2       and (not HFlagsGlb.FlNum2)
     then FontDimenGlb.Num2       :=FDim.Num2;
  if HFlags.FlNum3       and (not HFlagsGlb.FlNum3)
     then FontDimenGlb.Num3       :=FDim.Num3;
  if HFlags.FlDenom1     and (not HFlagsGlb.FlDenom1)
     then FontDimenGlb.Denom1     :=FDim.Denom1;
  if HFlags.FlDenom2     and (not HFlagsGlb.FlDenom2)
     then FontDimenGlb.Denom2     :=FDim.Denom2;
  if HFlags.FlSup1       and (not HFlagsGlb.FlSup1)
     then FontDimenGlb.Sup1       :=FDim.Sup1;
  if HFlags.FlSup2       and (not HFlagsGlb.FlSup2)
     then FontDimenGlb.Sup2       :=FDim.Sup2;
  if HFlags.FlSup3       and (not HFlagsGlb.FlSup3)
     then FontDimenGlb.Sup3       :=FDim.Sup3;
  if HFlags.FlSub1       and (not HFlagsGlb.FlSub1)
     then FontDimenGlb.Sub1       :=FDim.Sub1;
  if HFlags.FlSub2       and (not HFlagsGlb.FlSub2)
     then FontDimenGlb.Sub2       :=FDim.Sub2;
  if HFlags.FlSupDrop    and (not HFlagsGlb.FlSupDrop)
     then FontDimenGlb.SupDrop    :=FDim.SupDrop;
  if HFlags.FlSubDrop    and (not HFlagsGlb.FlSubDrop)
     then FontDimenGlb.SubDrop    :=FDim.SubDrop;
  if HFlags.FlDelim1     and (not HFlagsGlb.FlDelim1)
     then FontDimenGlb.Delim1     :=FDim.Delim1;
  if HFlags.FlDelim2     and (not HFlagsGlb.FlDelim2)
     then FontDimenGlb.Delim2     :=FDim.Delim2;
  if HFlags.FlAxisHeight and (not HFlagsGlb.FlAxisHeight)
     then FontDimenGlb.AxisHeight :=FDim.AxisHeight;

end; {JoinHeader}

