(function () {
    Avast.handlers.xhr = function (msg, context, callback) {
        var xhr = new XMLHttpRequest();

        var method = msg.options.method || (msg.data ? "POST" : "GET");


        //msg.url
        xhr.open(method, msg.url, true, msg.options.user, msg.options.password);

        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                var JSONableObj = {};
                for (var k in xhr) {
                    try {
                        if ((typeof xhr[k] !== 'function' && typeof xhr[k] !== 'object') || (k === 'response' && msg.options && msg.options.responseType)) {
                            JSONableObj[k] = xhr[k];
                        }
                    }
                    catch (e) { }
                }
                callback(JSONableObj);
            }
        };

        if (msg.options && msg.options.responseType) {
            xhr.responseType = msg.options.responseType;
        }

        // TODO: check on IE 8, may not process send() parameters
        try {
            xhr.send(msg.data);
        }
        catch (e) {
            callback({ status: 500, response: e.toString() });
        }
    };

    Avast.handlers.xhr64 = function (msg, context, callback) {
        if (msg.data) {
            msg.data = Avast.base64.decode(msg.data);
        }

        if (!msg.options) {
            msg.options = {};
        }
        if (!msg.options.responseType) {
            msg.options.responseType = "arraybuffer";
        }

        Avast.handlers.xhr(msg, context, function (xhrData) {
            if (xhrData.response && xhrData.status > 0 && xhrData.status < 300) {
                xhrData.response = Avast.base64.encode(new Uint8Array(xhrData.response));
                xhrData.responseText = xhrData.response;
                xhrData.responseXML = null;
            }

            callback(xhrData);
        })
    }
})();
