'''

The MIT License (MIT)

Copyright (c) 2016 Gehad Shaat

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

'''

def can_paginate(operation_name=None):
    """
    Check if an operation can be paginated.
    
    :type operation_name: string
    :param operation_name: The operation name. This is the same name
            as the method name on the client. For example, if the
            method name is create_foo, and you'd normally invoke the
            operation as client.create_foo(**kwargs), if the
            create_foo operation can be paginated, you can use the
            call client.get_paginator('create_foo').

    """
    pass

def create_file_system(CreationToken=None, PerformanceMode=None):
    """
    Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does not currently exist that is owned by the caller's AWS account with the specified creation token, this operation does the following:
    Otherwise, this operation returns a FileSystemAlreadyExists error with the ID of the existing file system.
    The idempotent operation allows you to retry a CreateFileSystem call without risk of creating an extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a file system was actually created. An example might be that a transport level timeout occurred or your connection was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file system, the client can learn of its existence from the FileSystemAlreadyExists error.
    This operation also takes an optional PerformanceMode parameter that you choose for your file system. We recommend generalPurpose performance mode for most file systems. File systems using the maxIO performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created. For more information, see Amazon EFS: Performance Modes .
    After the file system is fully created, Amazon EFS sets its lifecycle state to available , at which point you can create one or more mount targets for the file system in your VPC. For more information, see  CreateMountTarget . You mount your Amazon EFS file system on an EC2 instances in your VPC via the mount target. For more information, see Amazon EFS: How it Works .
    This operation requires permissions for the elasticfilesystem:CreateFileSystem action.
    
    
    :example: response = client.create_file_system(
        CreationToken='string',
        PerformanceMode='generalPurpose'|'maxIO'
    )
    
    
    :type CreationToken: string
    :param CreationToken: [REQUIRED]
            String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
            

    :type PerformanceMode: string
    :param PerformanceMode: The PerformanceMode of the file system. We recommend generalPurpose performance mode for most file systems. File systems using the maxIO performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. This can't be changed after the file system has been created.

    :rtype: dict
    :return: {
        'OwnerId': 'string',
        'CreationToken': 'string',
        'FileSystemId': 'string',
        'CreationTime': datetime(2015, 1, 1),
        'LifeCycleState': 'creating'|'available'|'deleting'|'deleted',
        'Name': 'string',
        'NumberOfMountTargets': 123,
        'SizeInBytes': {
            'Value': 123,
            'Timestamp': datetime(2015, 1, 1)
        },
        'PerformanceMode': 'generalPurpose'|'maxIO'
    }
    
    
    :returns: 
    CreationToken (string) -- [REQUIRED]
    String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
    
    PerformanceMode (string) -- The PerformanceMode of the file system. We recommend generalPurpose performance mode for most file systems. File systems using the maxIO performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. This can't be changed after the file system has been created.
    
    """
    pass

def create_mount_target(FileSystemId=None, SubnetId=None, IpAddress=None, SecurityGroups=None):
    """
    Creates a mount target for a file system. You can then mount the file system on EC2 instances via the mount target.
    You can create one mount target in each Availability Zone in your VPC. All EC2 instances in a VPC within a given Availability Zone share a single mount target for a given file system. If you have multiple subnets in an Availability Zone, you create a mount target in one of the subnets. EC2 instances do not need to be in the same subnet as the mount target in order to access their file system. For more information, see Amazon EFS: How it Works .
    In the request, you also specify a file system ID for which you are creating the mount target and the file system's lifecycle state must be available . For more information, see  DescribeFileSystems .
    In the request, you also provide a subnet ID, which determines the following:
    After creating the mount target, Amazon EFS returns a response that includes, a MountTargetId and an IpAddress . You use this IP address when mounting the file system in an EC2 instance. You can also use the mount target's DNS name when mounting the file system. The EC2 instance on which you mount the file system via the mount target can resolve the mount target's DNS name to its IP address. For more information, see How it Works: Implementation Overview .
    Note that you can create mount targets for a file system in only one VPC, and there can be only one mount target per Availability Zone. That is, if the file system already has one or more mount targets created for it, the subnet specified in the request to add another mount target must meet the following requirements:
    If the request satisfies the requirements, Amazon EFS does the following:
    Each Amazon EFS mount target has one corresponding requestor-managed EC2 network interface. After the network interface is created, Amazon EFS sets the NetworkInterfaceId field in the mount target's description to the network interface ID, and the IpAddress field to its address. If network interface creation fails, the entire CreateMountTarget operation fails.
    We recommend you create a mount target in each of the Availability Zones. There are cost considerations for using a file system in an Availability Zone through a mount target created in another Availability Zone. For more information, see Amazon EFS . In addition, by always using a mount target local to the instance's Availability Zone, you eliminate a partial failure scenario. If the Availability Zone in which your mount target is created goes down, then you won't be able to access your file system through that mount target.
    This operation requires permissions for the following action on the file system:
    This operation also requires permissions for the following Amazon EC2 actions:
    
    
    :example: response = client.create_mount_target(
        FileSystemId='string',
        SubnetId='string',
        IpAddress='string',
        SecurityGroups=[
            'string',
        ]
    )
    
    
    :type FileSystemId: string
    :param FileSystemId: [REQUIRED]
            ID of the file system for which to create the mount target.
            

    :type SubnetId: string
    :param SubnetId: [REQUIRED]
            ID of the subnet to add the mount target in.
            

    :type IpAddress: string
    :param IpAddress: Valid IPv4 address within the address range of the specified subnet.

    :type SecurityGroups: list
    :param SecurityGroups: Up to five VPC security group IDs, of the form sg-xxxxxxxx . These must be for the same VPC as subnet specified.
            (string) --
            

    :rtype: dict
    :return: {
        'OwnerId': 'string',
        'MountTargetId': 'string',
        'FileSystemId': 'string',
        'SubnetId': 'string',
        'LifeCycleState': 'creating'|'available'|'deleting'|'deleted',
        'IpAddress': 'string',
        'NetworkInterfaceId': 'string'
    }
    
    
    :returns: 
    Must belong to the same VPC as the subnets of the existing mount targets
    Must not be in the same Availability Zone as any of the subnets of the existing mount targets
    
    """
    pass

def create_tags(FileSystemId=None, Tags=None):
    """
    Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in the request already exists on the file system, this operation overwrites its value with the value provided in the request. If you add the Name tag to your file system, Amazon EFS returns it in the response to the  DescribeFileSystems operation.
    This operation requires permission for the elasticfilesystem:CreateTags action.
    
    
    :example: response = client.create_tags(
        FileSystemId='string',
        Tags=[
            {
                'Key': 'string',
                'Value': 'string'
            },
        ]
    )
    
    
    :type FileSystemId: string
    :param FileSystemId: [REQUIRED]
            ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the file system.
            

    :type Tags: list
    :param Tags: [REQUIRED]
            Array of Tag objects to add. Each Tag object is a key-value pair.
            (dict) --A tag is a key-value pair. Allowed characters: letters, whitespace, and numbers, representable in UTF-8, and the following characters:+ - = . _ : /
            Key (string) -- [REQUIRED]Tag key (String). The key can't start with aws: .
            Value (string) -- [REQUIRED]Value of the tag key.
            
            

    """
    pass

def delete_file_system(FileSystemId=None):
    """
    Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists and you can't access any contents of the deleted file system.
    You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first delete them. For more information, see  DescribeMountTargets and  DeleteMountTarget .
    This operation requires permissions for the elasticfilesystem:DeleteFileSystem action.
    
    
    :example: response = client.delete_file_system(
        FileSystemId='string'
    )
    
    
    :type FileSystemId: string
    :param FileSystemId: [REQUIRED]
            ID of the file system you want to delete.
            

    """
    pass

def delete_mount_target(MountTargetId=None):
    """
    Deletes the specified mount target.
    This operation forcibly breaks any mounts of the file system via the mount target that is being deleted, which might disrupt instances or applications using those mounts. To avoid applications getting cut off abruptly, you might consider unmounting any mounts of the mount target, if feasible. The operation also deletes the associated network interface. Uncommitted writes may be lost, but breaking a mount target using this operation does not corrupt the file system itself. The file system you created remains. You can mount an EC2 instance in your VPC via another mount target.
    This operation requires permissions for the following action on the file system:
    The operation also requires permissions for the following Amazon EC2 action on the mount target's network interface:
    
    
    :example: response = client.delete_mount_target(
        MountTargetId='string'
    )
    
    
    :type MountTargetId: string
    :param MountTargetId: [REQUIRED]
            ID of the mount target to delete (String).
            

    :returns: 
    ec2:DeleteNetworkInterface
    
    """
    pass

def delete_tags(FileSystemId=None, TagKeys=None):
    """
    Deletes the specified tags from a file system. If the DeleteTags request includes a tag key that does not exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related restrictions, see Tag Restrictions in the AWS Billing and Cost Management User Guide .
    This operation requires permissions for the elasticfilesystem:DeleteTags action.
    
    
    :example: response = client.delete_tags(
        FileSystemId='string',
        TagKeys=[
            'string',
        ]
    )
    
    
    :type FileSystemId: string
    :param FileSystemId: [REQUIRED]
            ID of the file system whose tags you want to delete (String).
            

    :type TagKeys: list
    :param TagKeys: [REQUIRED]
            List of tag keys to delete.
            (string) --
            

    """
    pass

def describe_file_systems(MaxItems=None, Marker=None, CreationToken=None, FileSystemId=None):
    """
    Returns the description of a specific Amazon EFS file system if either the file system CreationToken or the FileSystemId is provided. Otherwise, it returns descriptions of all file systems owned by the caller's AWS account in the AWS Region of the endpoint that you're calling.
    When retrieving all file system descriptions, you can optionally specify the MaxItems parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon EFS returns a NextMarker , an opaque token, in the response. In this case, you should send a subsequent request with the Marker request parameter set to the value of NextMarker .
    To retrieve a list of your file system descriptions, this operation is used in an iterative process, where DescribeFileSystems is called first without the Marker and then the operation continues to call it with the Marker parameter set to the value of the NextMarker from the previous response until the response has no NextMarker .
    The implementation may return fewer than MaxItems file system descriptions while still including a NextMarker value.
    The order of file systems returned in the response of one DescribeFileSystems call and the order of file systems returned across the responses of a multi-call iteration is unspecified.
    This operation requires permissions for the elasticfilesystem:DescribeFileSystems action.
    
    
    :example: response = client.describe_file_systems(
        MaxItems=123,
        Marker='string',
        CreationToken='string',
        FileSystemId='string'
    )
    
    
    :type MaxItems: integer
    :param MaxItems: (Optional) Specifies the maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon EFS returns is the minimum of the MaxItems parameter specified in the request and the service's internal maximum number of items per page.

    :type Marker: string
    :param Marker: (Optional) Opaque pagination token returned from a previous DescribeFileSystems operation (String). If present, specifies to continue the list from where the returning call had left off.

    :type CreationToken: string
    :param CreationToken: (Optional) Restricts the list to the file system with this creation token (String). You specify a creation token when you create an Amazon EFS file system.

    :type FileSystemId: string
    :param FileSystemId: (Optional) ID of the file system whose description you want to retrieve (String).

    :rtype: dict
    :return: {
        'Marker': 'string',
        'FileSystems': [
            {
                'OwnerId': 'string',
                'CreationToken': 'string',
                'FileSystemId': 'string',
                'CreationTime': datetime(2015, 1, 1),
                'LifeCycleState': 'creating'|'available'|'deleting'|'deleted',
                'Name': 'string',
                'NumberOfMountTargets': 123,
                'SizeInBytes': {
                    'Value': 123,
                    'Timestamp': datetime(2015, 1, 1)
                },
                'PerformanceMode': 'generalPurpose'|'maxIO'
            },
        ],
        'NextMarker': 'string'
    }
    
    
    """
    pass

def describe_mount_target_security_groups(MountTargetId=None):
    """
    Returns the security groups currently in effect for a mount target. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not deleted .
    This operation requires permissions for the following actions:
    
    
    :example: response = client.describe_mount_target_security_groups(
        MountTargetId='string'
    )
    
    
    :type MountTargetId: string
    :param MountTargetId: [REQUIRED]
            ID of the mount target whose security groups you want to retrieve.
            

    :rtype: dict
    :return: {
        'SecurityGroups': [
            'string',
        ]
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def describe_mount_targets(MaxItems=None, Marker=None, FileSystemId=None, MountTargetId=None):
    """
    Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.
    This operation requires permissions for the elasticfilesystem:DescribeMountTargets action, on either the file system ID that you specify in FileSystemId , or on the file system of the mount target that you specify in MountTargetId .
    
    
    :example: response = client.describe_mount_targets(
        MaxItems=123,
        Marker='string',
        FileSystemId='string',
        MountTargetId='string'
    )
    
    
    :type MaxItems: integer
    :param MaxItems: (Optional) Maximum number of mount targets to return in the response. It must be an integer with a value greater than zero.

    :type Marker: string
    :param Marker: (Optional) Opaque pagination token returned from a previous DescribeMountTargets operation (String). If present, it specifies to continue the list from where the previous returning call left off.

    :type FileSystemId: string
    :param FileSystemId: (Optional) ID of the file system whose mount targets you want to list (String). It must be included in your request if MountTargetId is not included.

    :type MountTargetId: string
    :param MountTargetId: (Optional) ID of the mount target that you want to have described (String). It must be included in your request if FileSystemId is not included.

    :rtype: dict
    :return: {
        'Marker': 'string',
        'MountTargets': [
            {
                'OwnerId': 'string',
                'MountTargetId': 'string',
                'FileSystemId': 'string',
                'SubnetId': 'string',
                'LifeCycleState': 'creating'|'available'|'deleting'|'deleted',
                'IpAddress': 'string',
                'NetworkInterfaceId': 'string'
            },
        ],
        'NextMarker': 'string'
    }
    
    
    """
    pass

def describe_tags(MaxItems=None, Marker=None, FileSystemId=None):
    """
    Returns the tags associated with a file system. The order of tags returned in the response of one DescribeTags call and the order of tags returned across the responses of a multi-call iteration (when using pagination) is unspecified.
    This operation requires permissions for the elasticfilesystem:DescribeTags action.
    
    
    :example: response = client.describe_tags(
        MaxItems=123,
        Marker='string',
        FileSystemId='string'
    )
    
    
    :type MaxItems: integer
    :param MaxItems: (Optional) Maximum number of file system tags to return in the response. It must be an integer with a value greater than zero.

    :type Marker: string
    :param Marker: (Optional) Opaque pagination token returned from a previous DescribeTags operation (String). If present, it specifies to continue the list from where the previous call left off.

    :type FileSystemId: string
    :param FileSystemId: [REQUIRED]
            ID of the file system whose tag set you want to retrieve.
            

    :rtype: dict
    :return: {
        'Marker': 'string',
        'Tags': [
            {
                'Key': 'string',
                'Value': 'string'
            },
        ],
        'NextMarker': 'string'
    }
    
    
    """
    pass

def generate_presigned_url(ClientMethod=None, Params=None, ExpiresIn=None, HttpMethod=None):
    """
    Generate a presigned url given a client, its method, and arguments
    
    :type ClientMethod: string
    :param ClientMethod: The client method to presign for

    :type Params: dict
    :param Params: The parameters normally passed to
            ClientMethod.

    :type ExpiresIn: int
    :param ExpiresIn: The number of seconds the presigned url is valid
            for. By default it expires in an hour (3600 seconds)

    :type HttpMethod: string
    :param HttpMethod: The http method to use on the generated url. By
            default, the http method is whatever is used in the method's model.

    """
    pass

def get_paginator(operation_name=None):
    """
    Create a paginator for an operation.
    
    :type operation_name: string
    :param operation_name: The operation name. This is the same name
            as the method name on the client. For example, if the
            method name is create_foo, and you'd normally invoke the
            operation as client.create_foo(**kwargs), if the
            create_foo operation can be paginated, you can use the
            call client.get_paginator('create_foo').

    :rtype: L{botocore.paginate.Paginator}
    """
    pass

def get_waiter():
    """
    
    """
    pass

def modify_mount_target_security_groups(MountTargetId=None, SecurityGroups=None):
    """
    Modifies the set of security groups in effect for a mount target.
    When you create a mount target, Amazon EFS also creates a new network interface. For more information, see  CreateMountTarget . This operation replaces the security groups in effect for the network interface associated with a mount target, with the SecurityGroups provided in the request. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not deleted .
    The operation requires permissions for the following actions:
    
    
    :example: response = client.modify_mount_target_security_groups(
        MountTargetId='string',
        SecurityGroups=[
            'string',
        ]
    )
    
    
    :type MountTargetId: string
    :param MountTargetId: [REQUIRED]
            ID of the mount target whose security groups you want to modify.
            

    :type SecurityGroups: list
    :param SecurityGroups: Array of up to five VPC security group IDs.
            (string) --
            

    :returns: 
    MountTargetId (string) -- [REQUIRED]
    ID of the mount target whose security groups you want to modify.
    
    SecurityGroups (list) -- Array of up to five VPC security group IDs.
    
    (string) --
    
    
    
    """
    pass

