# -*- coding: utf-8 -*-
#
# This file is part of SENAITE.PATIENT.
#
# SENAITE.PATIENT is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright 2020-2022 by it's authors.
# Some rights reserved, see README and LICENSE.

from zope.i18nmessageid import MessageFactory
from senaite.patient.catalog import PATIENT_CATALOG  # noqa

_ = MessageFactory("senaite.patient")

PRODUCT_NAME = "senaite.patient"

DEFAULT_ROLES = ("Manager", )

DEFAULT_TYPES = ("PatientFolder", "Patient", )

AUTO_ID_MARKER = "-- autogenerated --"

GENDERS = (
    ("m", _("Male")),
    ("f", _("Female")),
    ("d", _("Diverse")),
    ("", _("Not Specified")),
)

NAME_ENTRY_MODES = (
    ("parts", _("First name + last name")),
    ("full", _("Fullname")),
)


IDENTIFIERS = (
    (u"passport_id", _(u"Passport ID")),
    (u"national_id", _(u"National ID")),
    (u"driver_id", _(u"Driver ID")),
    (u"voter_id", _(u"Voter ID")),
)
