
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class AssignedDiscount(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getAssignedDiscounts(self,couponSetCode):
		""" 
		
		Args:
			| couponSetCode (string) - 
		
		Returns:
			| array of AssignedDiscount 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/assigneddiscounts", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def assignDiscount(self,assignedDiscount, couponSetCode):
		""" 
		
		Args:
			| assignedDiscount(assignedDiscount) - 
			| couponSetCode (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/assigneddiscounts", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		self.client.withResourceUrl(url).withBody(assignedDiscount).execute();

	
		
	def unAssignDiscount(self,couponSetCode, discountId):
		""" 
		
		Args:
			| couponSetCode (string) - 
			| discountId (int) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/assigneddiscounts/{discountId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		url.formatUrl("discountId", discountId);
		self.client.withResourceUrl(url).execute();

	
	
	