
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Pickup(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getAvailablePickupFulfillmentActions(self,orderId, pickupId):
		""" Retrieves a list of the actions available to perform for the pickup specified in the request.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| pickupId (string) - Unique identifier of the pickup to remove.
		
		Returns:
			| array of string 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/pickups/{pickupId}/actions", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("pickupId", pickupId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPickup(self,orderId, pickupId, responseFields = None):
		""" Retrieves the details of the in-store pickup specified in the request.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| pickupId (string) - Unique identifier of the pickup to remove.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Pickup 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/pickups/{pickupId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("pickupId", pickupId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createPickup(self,pickup, orderId, responseFields = None):
		""" Create a new pickup for the order specified in the request for in-store fufillment.
		
		Args:
			| pickup(pickup) - Properties of an in-store pickup defined to fulfill items in an order.
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Pickup 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/pickups?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(pickup).execute();
		return self.client.result();

	
		
	def updatePickup(self,pickup, orderId, pickupId, responseFields = None):
		""" Updates one or more details of a defined in-store pickup.
		
		Args:
			| pickup(pickup) - Properties of an in-store pickup defined to fulfill items in an order.
			| orderId (string) - Unique identifier of the order.
			| pickupId (string) - Unique identifier of the pickup to remove.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Pickup 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/pickups/{pickupId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("pickupId", pickupId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(pickup).execute();
		return self.client.result();

	
		
	def deletePickup(self,orderId, pickupId):
		""" Removes a pickup previously defined for order item in-store pickup fulfillment.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| pickupId (string) - Unique identifier of the pickup to remove.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/pickups/{pickupId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("pickupId", pickupId);
		self.client.withResourceUrl(url).execute();

	
	
	