
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class PaymentSettings(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getThirdPartyPaymentWorkflowWithValues(self,fullyQualifiedName, responseFields = None):
		""" checkout-paymentsettings Get GetThirdPartyPaymentWorkflowWithValues description DOCUMENT_HERE 
		
		Args:
			| fullyQualifiedName (string) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| ExternalPaymentWorkflowDefinition 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/checkout/paymentsettings/thirdpartyworkflow/{fullyQualifiedName}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("fullyQualifiedName", fullyQualifiedName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getThirdPartyPaymentWorkflows(self,):
		""" Retrieves the details of the third-party payment service workflows configured for the site.
		
		Returns:
			| array of ExternalPaymentWorkflowDefinition 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/checkout/paymentsettings/thirdpartyworkflows", "GET", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addThirdPartyPaymentWorkflow(self,definition):
		""" checkout-paymentsettings Put AddThirdPartyPaymentWorkflow description DOCUMENT_HERE 
		
		Args:
			| definition(definition) - Properties of an external payment processing workflow defined for the site. At this time, only PayPal Express is supported.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/checkout/paymentsettings/thirdpartyworkflows", "PUT", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).withBody(definition).execute();

	
		
	def deleteThirdPartyPaymentWorkflow(self,fullyQualifiedName):
		""" checkout-paymentsettings Delete DeleteThirdPartyPaymentWorkflow description DOCUMENT_HERE 
		
		Args:
			| fullyQualifiedName (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/checkout/paymentsettings/thirdpartyworkflows/{fullyQualifiedName}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("fullyQualifiedName", fullyQualifiedName);
		self.client.withResourceUrl(url).execute();

	
	
	