# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterDiskEncryptionParameters(Model):
    """The Disk Encryption Cluster request parameters.

    :param vault_uri: Base key vault URI where the customers key is located
     eg. https://myvault.vault.azure.net
    :type vault_uri: str
    :param key_name: Key name that is used for enabling disk encryption.
    :type key_name: str
    :param key_version: Specific key version that is used for enabling disk
     encryption.
    :type key_version: str
    """

    _attribute_map = {
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterDiskEncryptionParameters, self).__init__(**kwargs)
        self.vault_uri = kwargs.get('vault_uri', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)
