/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.authentication.crypto;

import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.ow2.proactive.authentication.crypto.KeyUtil;

public class KeyPairUtil {
    public static void generateKeyPair(String algorithm, int size, String privPath, String pubPath) throws KeyException {
        Throwable throwable;
        FileOutputStream out;
        KeyPair keyPair = KeyPairUtil.generateKeyPair(algorithm, size);
        PrivateKey privKey = keyPair.getPrivate();
        PublicKey pubKey = keyPair.getPublic();
        try {
            out = new FileOutputStream(new File(privPath));
            throwable = null;
            try {
                out.write(privKey.getEncoded());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KeyException("Cannot write private key to disk", e);
        }
        try {
            out = new FileOutputStream(new File(pubPath));
            throwable = null;
            try {
                out.write((algorithm + "\n").getBytes());
                out.write((size + "\n").getBytes());
                out.write(pubKey.getEncoded());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KeyException("Cannot write public key to disk", e);
        }
    }

    public static synchronized KeyPair generateKeyPair(String algorithm, int size) throws KeyException {
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException("Cannot initialize keypair generator", e);
        }
        SecureRandom random = KeyUtil.getSecureRandom();
        keyGen.initialize(size, random);
        return keyGen.generateKeyPair();
    }

    public static synchronized byte[] encrypt(PublicKey pubKey, String cipherParams, byte[] message) throws KeyException {
        Cipher ciph = null;
        try {
            ciph = Cipher.getInstance(cipherParams);
            ciph.init(1, (Key)pubKey, KeyUtil.getSecureRandom());
        }
        catch (Exception e) {
            throw new KeyException("Could not initialize cipher", e);
        }
        byte[] res = null;
        try {
            res = ciph.doFinal(message);
        }
        catch (Exception e) {
            throw new KeyException("Could not encrypt message.", e);
        }
        return res;
    }

    public static synchronized byte[] decrypt(PrivateKey privKey, String cipherParams, byte[] message) throws KeyException {
        Cipher ciph = null;
        try {
            ciph = Cipher.getInstance(cipherParams);
            ciph.init(2, (Key)privKey, KeyUtil.getSecureRandom());
        }
        catch (Exception e) {
            throw new KeyException("Could not initialize cipher", e);
        }
        byte[] res = null;
        try {
            res = ciph.doFinal(message);
        }
        catch (Exception e) {
            throw new KeyException("Could not descrypt message.", e);
        }
        return res;
    }
}

