/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.ds;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive_grid_cloud_portal.scheduler.client.utils.Zipper;

public class LocalDirSource
implements IDataSpaceClient.ILocalSource {
    private File source;
    private List<String> includes;
    private List<String> excludes;

    public LocalDirSource(File dir) {
        Preconditions.checkArgument((boolean)dir.isDirectory());
        this.source = dir;
    }

    public LocalDirSource(String path) {
        this(new File(path));
    }

    public void setIncludes(List<String> includes) {
        Preconditions.checkNotNull(includes);
        this.includes = Lists.newArrayList(includes);
    }

    public void setIncludes(String ... includes) {
        Preconditions.checkNotNull((Object)includes);
        this.includes = Lists.newArrayList((Object[])includes);
    }

    public void setExcludes(List<String> excludes) {
        Preconditions.checkNotNull(excludes);
        this.excludes = Lists.newArrayList(excludes);
    }

    public void setExcludes(String ... excludes) {
        Preconditions.checkNotNull((Object)excludes);
        this.excludes = Lists.newArrayList((Object[])excludes);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Zipper.ZIP.zip((File)this.source, this.includes, this.excludes, (OutputStream)outputStream);
    }

    @Override
    public String getEncoding() throws IOException {
        return "zip";
    }

    public String toString() {
        return "LocalDirSource{source=" + this.source + ", includes=" + this.includes + ", excludes=" + this.excludes + '}';
    }
}

