/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.ds;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive_grid_cloud_portal.scheduler.client.utils.Zipper;

public class LocalFileSource
implements IDataSpaceClient.ILocalSource {
    private File file;

    public LocalFileSource(File file) {
        Preconditions.checkArgument((boolean)file.isFile());
        this.file = file;
    }

    public LocalFileSource(String path) {
        Preconditions.checkArgument((boolean)new File(path).isFile());
        this.file = new File(path);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (Zipper.isZipFile((File)this.file)) {
            Files.asByteSource((File)this.file).copyTo(outputStream);
        } else {
            Zipper.GZIP.zip((File)this.file, (OutputStream)outputStream);
        }
    }

    @Override
    public String getEncoding() throws IOException {
        return Zipper.isZipFile((File)this.file) ? null : "gzip";
    }

    public String toString() {
        return "LocalFileSource{file=" + this.file + '}';
    }
}

