# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Attestation(Resource):
    """An attestation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.policyinsights.models.SystemData
    :param policy_assignment_id: Required. The resource ID of the policy assignment that the
     attestation is setting the state for.
    :type policy_assignment_id: str
    :param policy_definition_reference_id: The policy definition reference ID from a policy set
     definition that the attestation is setting the state for. If the policy assignment assigns a
     policy set definition the attestation can choose a definition within the set definition with
     this property or omit this and set the state for the entire set definition.
    :type policy_definition_reference_id: str
    :param compliance_state: The compliance state that should be set on the resource. Possible
     values include: "Compliant", "NonCompliant", "Unknown".
    :type compliance_state: str or ~azure.mgmt.policyinsights.models.ComplianceState
    :param expires_on: The time the compliance state should expire.
    :type expires_on: ~datetime.datetime
    :param owner: The person responsible for setting the state of the resource. This value is
     typically an Azure Active Directory object ID.
    :type owner: str
    :param comments: Comments describing why this attestation was created.
    :type comments: str
    :param evidence: The evidence supporting the compliance state set in this attestation.
    :type evidence: list[~azure.mgmt.policyinsights.models.AttestationEvidence]
    :ivar provisioning_state: The status of the attestation.
    :vartype provisioning_state: str
    :ivar last_compliance_state_change_at: The time the compliance state was last changed in this
     attestation.
    :vartype last_compliance_state_change_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'policy_assignment_id': {'required': True},
        'provisioning_state': {'readonly': True},
        'last_compliance_state_change_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'policy_assignment_id': {'key': 'properties.policyAssignmentId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'properties.policyDefinitionReferenceId', 'type': 'str'},
        'compliance_state': {'key': 'properties.complianceState', 'type': 'str'},
        'expires_on': {'key': 'properties.expiresOn', 'type': 'iso-8601'},
        'owner': {'key': 'properties.owner', 'type': 'str'},
        'comments': {'key': 'properties.comments', 'type': 'str'},
        'evidence': {'key': 'properties.evidence', 'type': '[AttestationEvidence]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_compliance_state_change_at': {'key': 'properties.lastComplianceStateChangeAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Attestation, self).__init__(**kwargs)
        self.system_data = None
        self.policy_assignment_id = kwargs['policy_assignment_id']
        self.policy_definition_reference_id = kwargs.get('policy_definition_reference_id', None)
        self.compliance_state = kwargs.get('compliance_state', None)
        self.expires_on = kwargs.get('expires_on', None)
        self.owner = kwargs.get('owner', None)
        self.comments = kwargs.get('comments', None)
        self.evidence = kwargs.get('evidence', None)
        self.provisioning_state = None
        self.last_compliance_state_change_at = None


class AttestationEvidence(msrest.serialization.Model):
    """A piece of evidence supporting the compliance state set in the attestation.

    :param description: The description for this piece of evidence.
    :type description: str
    :param source_uri: The URI location of the evidence.
    :type source_uri: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'source_uri': {'key': 'sourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestationEvidence, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.source_uri = kwargs.get('source_uri', None)


class AttestationListResult(msrest.serialization.Model):
    """List of attestations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of attestation definitions.
    :vartype value: list[~azure.mgmt.policyinsights.models.Attestation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Attestation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CheckRestrictionsRequest(msrest.serialization.Model):
    """The check policy restrictions parameters describing the resource that is being evaluated.

    All required parameters must be populated in order to send to Azure.

    :param resource_details: Required. The information about the resource that will be evaluated.
    :type resource_details: ~azure.mgmt.policyinsights.models.CheckRestrictionsResourceDetails
    :param pending_fields: The list of fields and values that should be evaluated for potential
     restrictions.
    :type pending_fields: list[~azure.mgmt.policyinsights.models.PendingField]
    """

    _validation = {
        'resource_details': {'required': True},
    }

    _attribute_map = {
        'resource_details': {'key': 'resourceDetails', 'type': 'CheckRestrictionsResourceDetails'},
        'pending_fields': {'key': 'pendingFields', 'type': '[PendingField]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckRestrictionsRequest, self).__init__(**kwargs)
        self.resource_details = kwargs['resource_details']
        self.pending_fields = kwargs.get('pending_fields', None)


class CheckRestrictionsResourceDetails(msrest.serialization.Model):
    """The information about the resource that will be evaluated.

    All required parameters must be populated in order to send to Azure.

    :param resource_content: Required. The resource content. This should include whatever
     properties are already known and can be a partial set of all resource properties.
    :type resource_content: any
    :param api_version: The api-version of the resource content.
    :type api_version: str
    :param scope: The scope where the resource is being created. For example, if the resource is a
     child resource this would be the parent resource's resource ID.
    :type scope: str
    """

    _validation = {
        'resource_content': {'required': True},
    }

    _attribute_map = {
        'resource_content': {'key': 'resourceContent', 'type': 'object'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckRestrictionsResourceDetails, self).__init__(**kwargs)
        self.resource_content = kwargs['resource_content']
        self.api_version = kwargs.get('api_version', None)
        self.scope = kwargs.get('scope', None)


class CheckRestrictionsResult(msrest.serialization.Model):
    """The result of a check policy restrictions evaluation on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar field_restrictions: The restrictions that will be placed on various fields in the
     resource by policy.
    :vartype field_restrictions: list[~azure.mgmt.policyinsights.models.FieldRestrictions]
    :ivar content_evaluation_result: Evaluation results for the provided partial resource content.
    :vartype content_evaluation_result:
     ~azure.mgmt.policyinsights.models.CheckRestrictionsResultContentEvaluationResult
    """

    _validation = {
        'field_restrictions': {'readonly': True},
        'content_evaluation_result': {'readonly': True},
    }

    _attribute_map = {
        'field_restrictions': {'key': 'fieldRestrictions', 'type': '[FieldRestrictions]'},
        'content_evaluation_result': {'key': 'contentEvaluationResult', 'type': 'CheckRestrictionsResultContentEvaluationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckRestrictionsResult, self).__init__(**kwargs)
        self.field_restrictions = None
        self.content_evaluation_result = None


class CheckRestrictionsResultContentEvaluationResult(msrest.serialization.Model):
    """Evaluation results for the provided partial resource content.

    :param policy_evaluations: Policy evaluation results against the given resource content. This
     will indicate if the partial content that was provided will be denied as-is.
    :type policy_evaluations: list[~azure.mgmt.policyinsights.models.PolicyEvaluationResult]
    """

    _attribute_map = {
        'policy_evaluations': {'key': 'policyEvaluations', 'type': '[PolicyEvaluationResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckRestrictionsResultContentEvaluationResult, self).__init__(**kwargs)
        self.policy_evaluations = kwargs.get('policy_evaluations', None)


class ComplianceDetail(msrest.serialization.Model):
    """The compliance state rollup.

    :param compliance_state: The compliance state.
    :type compliance_state: str
    :param count: Summarized count value for this compliance state.
    :type count: int
    """

    _attribute_map = {
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComplianceDetail, self).__init__(**kwargs)
        self.compliance_state = kwargs.get('compliance_state', None)
        self.count = kwargs.get('count', None)


class ComponentEventDetails(msrest.serialization.Model):
    """Component event details.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param id: Component Id.
    :type id: str
    :param type: Component type.
    :type type: str
    :param name: Component name.
    :type name: str
    :param timestamp: Timestamp for component policy event record.
    :type timestamp: ~datetime.datetime
    :param tenant_id: Tenant ID for the policy event record.
    :type tenant_id: str
    :param principal_oid: Principal object ID for the user who initiated the resource component
     operation that triggered the policy event.
    :type principal_oid: str
    :param policy_definition_action: Policy definition action, i.e. effect.
    :type policy_definition_action: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_oid': {'key': 'principalOid', 'type': 'str'},
        'policy_definition_action': {'key': 'policyDefinitionAction', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentEventDetails, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.principal_oid = kwargs.get('principal_oid', None)
        self.policy_definition_action = kwargs.get('policy_definition_action', None)


class ComponentStateDetails(msrest.serialization.Model):
    """Component state details.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param id: Component Id.
    :type id: str
    :param type: Component type.
    :type type: str
    :param name: Component name.
    :type name: str
    :param timestamp: Component compliance evaluation timestamp.
    :type timestamp: ~datetime.datetime
    :param compliance_state: Component compliance state.
    :type compliance_state: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentStateDetails, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.compliance_state = kwargs.get('compliance_state', None)


class ErrorDefinition(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinition]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info: list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinition]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[TypedErrorInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorDefinitionAutoGenerated(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info: list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinitionAutoGenerated]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[TypedErrorInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinitionAutoGenerated, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorDefinitionAutoGenerated2(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated2]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info: list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinitionAutoGenerated2]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[TypedErrorInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinitionAutoGenerated2, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :param error: The error details.
    :type error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseAutoGenerated(msrest.serialization.Model):
    """Error response.

    :param error: The error details.
    :type error: ~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinitionAutoGenerated'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseAutoGenerated, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseAutoGenerated2(msrest.serialization.Model):
    """Error response.

    :param error: The error details.
    :type error: ~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated2
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinitionAutoGenerated2'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseAutoGenerated2, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExpressionEvaluationDetails(msrest.serialization.Model):
    """Evaluation details of policy language expressions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param result: Evaluation result.
    :type result: str
    :param expression: Expression evaluated.
    :type expression: str
    :ivar expression_kind: The kind of expression that was evaluated.
    :vartype expression_kind: str
    :param path: Property path if the expression is a field or an alias.
    :type path: str
    :param expression_value: Value of the expression.
    :type expression_value: any
    :param target_value: Target value to be compared with the expression value.
    :type target_value: any
    :param operator: Operator to compare the expression value and the target value.
    :type operator: str
    """

    _validation = {
        'expression_kind': {'readonly': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
        'expression_kind': {'key': 'expressionKind', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'expression_value': {'key': 'expressionValue', 'type': 'object'},
        'target_value': {'key': 'targetValue', 'type': 'object'},
        'operator': {'key': 'operator', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressionEvaluationDetails, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.expression = kwargs.get('expression', None)
        self.expression_kind = None
        self.path = kwargs.get('path', None)
        self.expression_value = kwargs.get('expression_value', None)
        self.target_value = kwargs.get('target_value', None)
        self.operator = kwargs.get('operator', None)


class FieldRestriction(msrest.serialization.Model):
    """The restrictions on a field imposed by a specific policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result: The type of restriction that is imposed on the field. Possible values include:
     "Required", "Removed", "Deny".
    :vartype result: str or ~azure.mgmt.policyinsights.models.FieldRestrictionResult
    :ivar default_value: The value that policy will set for the field if the user does not provide
     a value.
    :vartype default_value: str
    :ivar values: The values that policy either requires or denies for the field.
    :vartype values: list[str]
    :ivar policy: The details of the policy that is causing the field restriction.
    :vartype policy: ~azure.mgmt.policyinsights.models.PolicyReference
    """

    _validation = {
        'result': {'readonly': True},
        'default_value': {'readonly': True},
        'values': {'readonly': True},
        'policy': {'readonly': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'policy': {'key': 'policy', 'type': 'PolicyReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FieldRestriction, self).__init__(**kwargs)
        self.result = None
        self.default_value = None
        self.values = None
        self.policy = None


class FieldRestrictions(msrest.serialization.Model):
    """The restrictions that will be placed on a field in the resource by policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar field: The name of the field. This can be a top-level property like 'name' or 'type' or
     an Azure Policy field alias.
    :vartype field: str
    :param restrictions: The restrictions placed on that field by policy.
    :type restrictions: list[~azure.mgmt.policyinsights.models.FieldRestriction]
    """

    _validation = {
        'field': {'readonly': True},
    }

    _attribute_map = {
        'field': {'key': 'field', 'type': 'str'},
        'restrictions': {'key': 'restrictions', 'type': '[FieldRestriction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FieldRestrictions, self).__init__(**kwargs)
        self.field = None
        self.restrictions = kwargs.get('restrictions', None)


class IfNotExistsEvaluationDetails(msrest.serialization.Model):
    """Evaluation details of IfNotExists effect.

    :param resource_id: ID of the last evaluated resource for IfNotExists effect.
    :type resource_id: str
    :param total_resources: Total number of resources to which the existence condition is
     applicable.
    :type total_resources: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'total_resources': {'key': 'totalResources', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IfNotExistsEvaluationDetails, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.total_resources = kwargs.get('total_resources', None)


class Operation(msrest.serialization.Model):
    """Operation definition.

    :param name: Operation name.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.policyinsights.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Resource provider name.
    :type provider: str
    :param resource: Resource name on which the operation is performed.
    :type resource: str
    :param operation: Operation name.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationsListResults(msrest.serialization.Model):
    """List of available operations.

    :param odata_count: OData entity count; represents the number of operations returned.
    :type odata_count: int
    :param value: List of available operations.
    :type value: list[~azure.mgmt.policyinsights.models.Operation]
    """

    _validation = {
        'odata_count': {'minimum': 1},
    }

    _attribute_map = {
        'odata_count': {'key': '@odata\\.count', 'type': 'int'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsListResults, self).__init__(**kwargs)
        self.odata_count = kwargs.get('odata_count', None)
        self.value = kwargs.get('value', None)


class PendingField(msrest.serialization.Model):
    """A field that should be evaluated against Azure Policy to determine restrictions.

    All required parameters must be populated in order to send to Azure.

    :param field: Required. The name of the field. This can be a top-level property like 'name' or
     'type' or an Azure Policy field alias.
    :type field: str
    :param values: The list of potential values for the field that should be evaluated against
     Azure Policy.
    :type values: list[str]
    """

    _validation = {
        'field': {'required': True},
    }

    _attribute_map = {
        'field': {'key': 'field', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PendingField, self).__init__(**kwargs)
        self.field = kwargs['field']
        self.values = kwargs.get('values', None)


class PolicyAssignmentSummary(msrest.serialization.Model):
    """Policy assignment summary.

    :param policy_assignment_id: Policy assignment ID.
    :type policy_assignment_id: str
    :param policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :type policy_set_definition_id: str
    :param results: Compliance summary for the policy assignment.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    :param policy_definitions: Policy definitions summary.
    :type policy_definitions: list[~azure.mgmt.policyinsights.models.PolicyDefinitionSummary]
    :param policy_groups: Policy definition group summary.
    :type policy_groups: list[~azure.mgmt.policyinsights.models.PolicyGroupSummary]
    """

    _attribute_map = {
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
        'policy_definitions': {'key': 'policyDefinitions', 'type': '[PolicyDefinitionSummary]'},
        'policy_groups': {'key': 'policyGroups', 'type': '[PolicyGroupSummary]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyAssignmentSummary, self).__init__(**kwargs)
        self.policy_assignment_id = kwargs.get('policy_assignment_id', None)
        self.policy_set_definition_id = kwargs.get('policy_set_definition_id', None)
        self.results = kwargs.get('results', None)
        self.policy_definitions = kwargs.get('policy_definitions', None)
        self.policy_groups = kwargs.get('policy_groups', None)


class PolicyDefinitionSummary(msrest.serialization.Model):
    """Policy definition summary.

    :param policy_definition_id: Policy definition ID.
    :type policy_definition_id: str
    :param policy_definition_reference_id: Policy definition reference ID.
    :type policy_definition_reference_id: str
    :param policy_definition_group_names: Policy definition group names.
    :type policy_definition_group_names: list[str]
    :param effect: Policy effect, i.e. policy definition action.
    :type effect: str
    :param results: Compliance summary for the policy definition.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    """

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'policy_definition_group_names': {'key': 'policyDefinitionGroupNames', 'type': '[str]'},
        'effect': {'key': 'effect', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyDefinitionSummary, self).__init__(**kwargs)
        self.policy_definition_id = kwargs.get('policy_definition_id', None)
        self.policy_definition_reference_id = kwargs.get('policy_definition_reference_id', None)
        self.policy_definition_group_names = kwargs.get('policy_definition_group_names', None)
        self.effect = kwargs.get('effect', None)
        self.results = kwargs.get('results', None)


class PolicyDetails(msrest.serialization.Model):
    """The policy details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_definition_id: The ID of the policy definition.
    :vartype policy_definition_id: str
    :ivar policy_assignment_id: The ID of the policy assignment.
    :vartype policy_assignment_id: str
    :ivar policy_assignment_display_name: The display name of the policy assignment.
    :vartype policy_assignment_display_name: str
    :ivar policy_assignment_scope: The scope of the policy assignment.
    :vartype policy_assignment_scope: str
    :ivar policy_set_definition_id: The ID of the policy set definition.
    :vartype policy_set_definition_id: str
    :ivar policy_definition_reference_id: The policy definition reference ID within the policy set
     definition.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        'policy_definition_id': {'readonly': True},
        'policy_assignment_id': {'readonly': True},
        'policy_assignment_display_name': {'readonly': True},
        'policy_assignment_scope': {'readonly': True},
        'policy_set_definition_id': {'readonly': True},
        'policy_definition_reference_id': {'readonly': True},
    }

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_assignment_display_name': {'key': 'policyAssignmentDisplayName', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyDetails, self).__init__(**kwargs)
        self.policy_definition_id = None
        self.policy_assignment_id = None
        self.policy_assignment_display_name = None
        self.policy_assignment_scope = None
        self.policy_set_definition_id = None
        self.policy_definition_reference_id = None


class PolicyEvaluationDetails(msrest.serialization.Model):
    """Policy evaluation details.

    :param evaluated_expressions: Details of the evaluated expressions.
    :type evaluated_expressions:
     list[~azure.mgmt.policyinsights.models.ExpressionEvaluationDetails]
    :param if_not_exists_details: Evaluation details of IfNotExists effect.
    :type if_not_exists_details: ~azure.mgmt.policyinsights.models.IfNotExistsEvaluationDetails
    """

    _attribute_map = {
        'evaluated_expressions': {'key': 'evaluatedExpressions', 'type': '[ExpressionEvaluationDetails]'},
        'if_not_exists_details': {'key': 'ifNotExistsDetails', 'type': 'IfNotExistsEvaluationDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyEvaluationDetails, self).__init__(**kwargs)
        self.evaluated_expressions = kwargs.get('evaluated_expressions', None)
        self.if_not_exists_details = kwargs.get('if_not_exists_details', None)


class PolicyEvaluationResult(msrest.serialization.Model):
    """The result of a non-compliant policy evaluation against the given resource content.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_info: The details of the policy that was evaluated.
    :vartype policy_info: ~azure.mgmt.policyinsights.models.PolicyReference
    :ivar evaluation_result: The result of the policy evaluation against the resource. This will
     typically be 'NonCompliant' but may contain other values if errors were encountered.
    :vartype evaluation_result: str
    :ivar evaluation_details: The detailed results of the policy expressions and values that were
     evaluated.
    :vartype evaluation_details: ~azure.mgmt.policyinsights.models.PolicyEvaluationDetails
    """

    _validation = {
        'policy_info': {'readonly': True},
        'evaluation_result': {'readonly': True},
        'evaluation_details': {'readonly': True},
    }

    _attribute_map = {
        'policy_info': {'key': 'policyInfo', 'type': 'PolicyReference'},
        'evaluation_result': {'key': 'evaluationResult', 'type': 'str'},
        'evaluation_details': {'key': 'evaluationDetails', 'type': 'PolicyEvaluationDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyEvaluationResult, self).__init__(**kwargs)
        self.policy_info = None
        self.evaluation_result = None
        self.evaluation_details = None


class PolicyEvent(msrest.serialization.Model):
    """Policy event record.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param odata_id: OData entity ID; always set to null since policy event records do not have an
     entity ID.
    :type odata_id: str
    :param odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :type odata_context: str
    :param timestamp: Timestamp for the policy event record.
    :type timestamp: ~datetime.datetime
    :param resource_id: Resource ID.
    :type resource_id: str
    :param policy_assignment_id: Policy assignment ID.
    :type policy_assignment_id: str
    :param policy_definition_id: Policy definition ID.
    :type policy_definition_id: str
    :param effective_parameters: Effective parameters for the policy assignment.
    :type effective_parameters: str
    :param is_compliant: Flag which states whether the resource is compliant against the policy
     assignment it was evaluated against.
    :type is_compliant: bool
    :param subscription_id: Subscription ID.
    :type subscription_id: str
    :param resource_type: Resource type.
    :type resource_type: str
    :param resource_location: Resource location.
    :type resource_location: str
    :param resource_group: Resource group name.
    :type resource_group: str
    :param resource_tags: List of resource tags.
    :type resource_tags: str
    :param policy_assignment_name: Policy assignment name.
    :type policy_assignment_name: str
    :param policy_assignment_owner: Policy assignment owner.
    :type policy_assignment_owner: str
    :param policy_assignment_parameters: Policy assignment parameters.
    :type policy_assignment_parameters: str
    :param policy_assignment_scope: Policy assignment scope.
    :type policy_assignment_scope: str
    :param policy_definition_name: Policy definition name.
    :type policy_definition_name: str
    :param policy_definition_action: Policy definition action, i.e. effect.
    :type policy_definition_action: str
    :param policy_definition_category: Policy definition category.
    :type policy_definition_category: str
    :param policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :type policy_set_definition_id: str
    :param policy_set_definition_name: Policy set definition name, if the policy assignment is for
     a policy set.
    :type policy_set_definition_name: str
    :param policy_set_definition_owner: Policy set definition owner, if the policy assignment is
     for a policy set.
    :type policy_set_definition_owner: str
    :param policy_set_definition_category: Policy set definition category, if the policy assignment
     is for a policy set.
    :type policy_set_definition_category: str
    :param policy_set_definition_parameters: Policy set definition parameters, if the policy
     assignment is for a policy set.
    :type policy_set_definition_parameters: str
    :param management_group_ids: Comma separated list of management group IDs, which represent the
     hierarchy of the management groups the resource is under.
    :type management_group_ids: str
    :param policy_definition_reference_id: Reference ID for the policy definition inside the policy
     set, if the policy assignment is for a policy set.
    :type policy_definition_reference_id: str
    :param compliance_state: Compliance state of the resource.
    :type compliance_state: str
    :param tenant_id: Tenant ID for the policy event record.
    :type tenant_id: str
    :param principal_oid: Principal object ID for the user who initiated the resource operation
     that triggered the policy event.
    :type principal_oid: str
    :param components: Components events records populated only when URL contains
     $expand=components clause.
    :type components: list[~azure.mgmt.policyinsights.models.ComponentEventDetails]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odata_id': {'key': '@odata\\.id', 'type': 'str'},
        'odata_context': {'key': '@odata\\.context', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'effective_parameters': {'key': 'effectiveParameters', 'type': 'str'},
        'is_compliant': {'key': 'isCompliant', 'type': 'bool'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_tags': {'key': 'resourceTags', 'type': 'str'},
        'policy_assignment_name': {'key': 'policyAssignmentName', 'type': 'str'},
        'policy_assignment_owner': {'key': 'policyAssignmentOwner', 'type': 'str'},
        'policy_assignment_parameters': {'key': 'policyAssignmentParameters', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_definition_name': {'key': 'policyDefinitionName', 'type': 'str'},
        'policy_definition_action': {'key': 'policyDefinitionAction', 'type': 'str'},
        'policy_definition_category': {'key': 'policyDefinitionCategory', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_set_definition_name': {'key': 'policySetDefinitionName', 'type': 'str'},
        'policy_set_definition_owner': {'key': 'policySetDefinitionOwner', 'type': 'str'},
        'policy_set_definition_category': {'key': 'policySetDefinitionCategory', 'type': 'str'},
        'policy_set_definition_parameters': {'key': 'policySetDefinitionParameters', 'type': 'str'},
        'management_group_ids': {'key': 'managementGroupIds', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_oid': {'key': 'principalOid', 'type': 'str'},
        'components': {'key': 'components', 'type': '[ComponentEventDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyEvent, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.odata_id = kwargs.get('odata_id', None)
        self.odata_context = kwargs.get('odata_context', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.policy_assignment_id = kwargs.get('policy_assignment_id', None)
        self.policy_definition_id = kwargs.get('policy_definition_id', None)
        self.effective_parameters = kwargs.get('effective_parameters', None)
        self.is_compliant = kwargs.get('is_compliant', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_location = kwargs.get('resource_location', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.resource_tags = kwargs.get('resource_tags', None)
        self.policy_assignment_name = kwargs.get('policy_assignment_name', None)
        self.policy_assignment_owner = kwargs.get('policy_assignment_owner', None)
        self.policy_assignment_parameters = kwargs.get('policy_assignment_parameters', None)
        self.policy_assignment_scope = kwargs.get('policy_assignment_scope', None)
        self.policy_definition_name = kwargs.get('policy_definition_name', None)
        self.policy_definition_action = kwargs.get('policy_definition_action', None)
        self.policy_definition_category = kwargs.get('policy_definition_category', None)
        self.policy_set_definition_id = kwargs.get('policy_set_definition_id', None)
        self.policy_set_definition_name = kwargs.get('policy_set_definition_name', None)
        self.policy_set_definition_owner = kwargs.get('policy_set_definition_owner', None)
        self.policy_set_definition_category = kwargs.get('policy_set_definition_category', None)
        self.policy_set_definition_parameters = kwargs.get('policy_set_definition_parameters', None)
        self.management_group_ids = kwargs.get('management_group_ids', None)
        self.policy_definition_reference_id = kwargs.get('policy_definition_reference_id', None)
        self.compliance_state = kwargs.get('compliance_state', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.principal_oid = kwargs.get('principal_oid', None)
        self.components = kwargs.get('components', None)


class PolicyEventsQueryResults(msrest.serialization.Model):
    """Query results.

    :param odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :type odata_context: str
    :param odata_count: OData entity count; represents the number of policy event records returned.
    :type odata_count: int
    :param odata_next_link: Odata next link; URL to get the next set of results.
    :type odata_next_link: str
    :param value: Query results.
    :type value: list[~azure.mgmt.policyinsights.models.PolicyEvent]
    """

    _validation = {
        'odata_count': {'minimum': 0},
    }

    _attribute_map = {
        'odata_context': {'key': '@odata\\.context', 'type': 'str'},
        'odata_count': {'key': '@odata\\.count', 'type': 'int'},
        'odata_next_link': {'key': '@odata\\.nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[PolicyEvent]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyEventsQueryResults, self).__init__(**kwargs)
        self.odata_context = kwargs.get('odata_context', None)
        self.odata_count = kwargs.get('odata_count', None)
        self.odata_next_link = kwargs.get('odata_next_link', None)
        self.value = kwargs.get('value', None)


class PolicyGroupSummary(msrest.serialization.Model):
    """Policy definition group summary.

    :param policy_group_name: Policy group name.
    :type policy_group_name: str
    :param results: Compliance summary for the policy definition group.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    """

    _attribute_map = {
        'policy_group_name': {'key': 'policyGroupName', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyGroupSummary, self).__init__(**kwargs)
        self.policy_group_name = kwargs.get('policy_group_name', None)
        self.results = kwargs.get('results', None)


class PolicyMetadata(msrest.serialization.Model):
    """Policy metadata resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy metadata.
    :vartype id: str
    :ivar type: The type of the policy metadata.
    :vartype type: str
    :ivar name: The name of the policy metadata.
    :vartype name: str
    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: any
    :ivar description: The description of the policy metadata.
    :vartype description: str
    :ivar requirements: The requirements of the policy metadata.
    :vartype requirements: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'metadata_id': {'readonly': True},
        'category': {'readonly': True},
        'title': {'readonly': True},
        'owner': {'readonly': True},
        'additional_content_url': {'readonly': True},
        'metadata': {'readonly': True},
        'description': {'readonly': True},
        'requirements': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'metadata_id': {'key': 'properties.metadataId', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'owner': {'key': 'properties.owner', 'type': 'str'},
        'additional_content_url': {'key': 'properties.additionalContentUrl', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'requirements': {'key': 'properties.requirements', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyMetadata, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.metadata_id = None
        self.category = None
        self.title = None
        self.owner = None
        self.additional_content_url = None
        self.metadata = None
        self.description = None
        self.requirements = None


class PolicyMetadataCollection(msrest.serialization.Model):
    """Collection of policy metadata resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of policy metadata definitions.
    :vartype value: list[~azure.mgmt.policyinsights.models.SlimPolicyMetadata]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SlimPolicyMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyMetadataCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PolicyMetadataSlimProperties(msrest.serialization.Model):
    """The properties of the policy metadata, excluding properties containing large strings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: any
    """

    _validation = {
        'metadata_id': {'readonly': True},
        'category': {'readonly': True},
        'title': {'readonly': True},
        'owner': {'readonly': True},
        'additional_content_url': {'readonly': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'metadata_id': {'key': 'metadataId', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'additional_content_url': {'key': 'additionalContentUrl', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyMetadataSlimProperties, self).__init__(**kwargs)
        self.metadata_id = None
        self.category = None
        self.title = None
        self.owner = None
        self.additional_content_url = None
        self.metadata = None


class PolicyMetadataProperties(PolicyMetadataSlimProperties):
    """The properties of the policy metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: any
    :ivar description: The description of the policy metadata.
    :vartype description: str
    :ivar requirements: The requirements of the policy metadata.
    :vartype requirements: str
    """

    _validation = {
        'metadata_id': {'readonly': True},
        'category': {'readonly': True},
        'title': {'readonly': True},
        'owner': {'readonly': True},
        'additional_content_url': {'readonly': True},
        'metadata': {'readonly': True},
        'description': {'readonly': True},
        'requirements': {'readonly': True},
    }

    _attribute_map = {
        'metadata_id': {'key': 'metadataId', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'additional_content_url': {'key': 'additionalContentUrl', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'description': {'key': 'description', 'type': 'str'},
        'requirements': {'key': 'requirements', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyMetadataProperties, self).__init__(**kwargs)
        self.description = None
        self.requirements = None


class PolicyReference(msrest.serialization.Model):
    """Resource identifiers for a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_definition_id: The resource identifier of the policy definition.
    :vartype policy_definition_id: str
    :ivar policy_set_definition_id: The resource identifier of the policy set definition.
    :vartype policy_set_definition_id: str
    :ivar policy_definition_reference_id: The reference identifier of a specific policy definition
     within a policy set definition.
    :vartype policy_definition_reference_id: str
    :ivar policy_assignment_id: The resource identifier of the policy assignment.
    :vartype policy_assignment_id: str
    """

    _validation = {
        'policy_definition_id': {'readonly': True},
        'policy_set_definition_id': {'readonly': True},
        'policy_definition_reference_id': {'readonly': True},
        'policy_assignment_id': {'readonly': True},
    }

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyReference, self).__init__(**kwargs)
        self.policy_definition_id = None
        self.policy_set_definition_id = None
        self.policy_definition_reference_id = None
        self.policy_assignment_id = None


class PolicyState(msrest.serialization.Model):
    """Policy state record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param odata_id: OData entity ID; always set to null since policy state records do not have an
     entity ID.
    :type odata_id: str
    :param odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :type odata_context: str
    :param timestamp: Timestamp for the policy state record.
    :type timestamp: ~datetime.datetime
    :param resource_id: Resource ID.
    :type resource_id: str
    :param policy_assignment_id: Policy assignment ID.
    :type policy_assignment_id: str
    :param policy_definition_id: Policy definition ID.
    :type policy_definition_id: str
    :param effective_parameters: Effective parameters for the policy assignment.
    :type effective_parameters: str
    :param is_compliant: Flag which states whether the resource is compliant against the policy
     assignment it was evaluated against. This property is deprecated; please use ComplianceState
     instead.
    :type is_compliant: bool
    :param subscription_id: Subscription ID.
    :type subscription_id: str
    :param resource_type: Resource type.
    :type resource_type: str
    :param resource_location: Resource location.
    :type resource_location: str
    :param resource_group: Resource group name.
    :type resource_group: str
    :param resource_tags: List of resource tags.
    :type resource_tags: str
    :param policy_assignment_name: Policy assignment name.
    :type policy_assignment_name: str
    :param policy_assignment_owner: Policy assignment owner.
    :type policy_assignment_owner: str
    :param policy_assignment_parameters: Policy assignment parameters.
    :type policy_assignment_parameters: str
    :param policy_assignment_scope: Policy assignment scope.
    :type policy_assignment_scope: str
    :param policy_definition_name: Policy definition name.
    :type policy_definition_name: str
    :param policy_definition_action: Policy definition action, i.e. effect.
    :type policy_definition_action: str
    :param policy_definition_category: Policy definition category.
    :type policy_definition_category: str
    :param policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :type policy_set_definition_id: str
    :param policy_set_definition_name: Policy set definition name, if the policy assignment is for
     a policy set.
    :type policy_set_definition_name: str
    :param policy_set_definition_owner: Policy set definition owner, if the policy assignment is
     for a policy set.
    :type policy_set_definition_owner: str
    :param policy_set_definition_category: Policy set definition category, if the policy assignment
     is for a policy set.
    :type policy_set_definition_category: str
    :param policy_set_definition_parameters: Policy set definition parameters, if the policy
     assignment is for a policy set.
    :type policy_set_definition_parameters: str
    :param management_group_ids: Comma separated list of management group IDs, which represent the
     hierarchy of the management groups the resource is under.
    :type management_group_ids: str
    :param policy_definition_reference_id: Reference ID for the policy definition inside the policy
     set, if the policy assignment is for a policy set.
    :type policy_definition_reference_id: str
    :param compliance_state: Compliance state of the resource.
    :type compliance_state: str
    :param policy_evaluation_details: Policy evaluation details.
    :type policy_evaluation_details: ~azure.mgmt.policyinsights.models.PolicyEvaluationDetails
    :param policy_definition_group_names: Policy definition group names.
    :type policy_definition_group_names: list[str]
    :param components: Components state compliance records populated only when URL contains
     $expand=components clause.
    :type components: list[~azure.mgmt.policyinsights.models.ComponentStateDetails]
    :ivar policy_definition_version: Evaluated policy definition version.
    :vartype policy_definition_version: str
    :ivar policy_set_definition_version: Evaluated policy set definition version.
    :vartype policy_set_definition_version: str
    :ivar policy_assignment_version: Evaluated policy assignment version.
    :vartype policy_assignment_version: str
    """

    _validation = {
        'policy_definition_version': {'readonly': True},
        'policy_set_definition_version': {'readonly': True},
        'policy_assignment_version': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odata_id': {'key': '@odata\\.id', 'type': 'str'},
        'odata_context': {'key': '@odata\\.context', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'effective_parameters': {'key': 'effectiveParameters', 'type': 'str'},
        'is_compliant': {'key': 'isCompliant', 'type': 'bool'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_tags': {'key': 'resourceTags', 'type': 'str'},
        'policy_assignment_name': {'key': 'policyAssignmentName', 'type': 'str'},
        'policy_assignment_owner': {'key': 'policyAssignmentOwner', 'type': 'str'},
        'policy_assignment_parameters': {'key': 'policyAssignmentParameters', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_definition_name': {'key': 'policyDefinitionName', 'type': 'str'},
        'policy_definition_action': {'key': 'policyDefinitionAction', 'type': 'str'},
        'policy_definition_category': {'key': 'policyDefinitionCategory', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_set_definition_name': {'key': 'policySetDefinitionName', 'type': 'str'},
        'policy_set_definition_owner': {'key': 'policySetDefinitionOwner', 'type': 'str'},
        'policy_set_definition_category': {'key': 'policySetDefinitionCategory', 'type': 'str'},
        'policy_set_definition_parameters': {'key': 'policySetDefinitionParameters', 'type': 'str'},
        'management_group_ids': {'key': 'managementGroupIds', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'policy_evaluation_details': {'key': 'policyEvaluationDetails', 'type': 'PolicyEvaluationDetails'},
        'policy_definition_group_names': {'key': 'policyDefinitionGroupNames', 'type': '[str]'},
        'components': {'key': 'components', 'type': '[ComponentStateDetails]'},
        'policy_definition_version': {'key': 'policyDefinitionVersion', 'type': 'str'},
        'policy_set_definition_version': {'key': 'policySetDefinitionVersion', 'type': 'str'},
        'policy_assignment_version': {'key': 'policyAssignmentVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyState, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.odata_id = kwargs.get('odata_id', None)
        self.odata_context = kwargs.get('odata_context', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.policy_assignment_id = kwargs.get('policy_assignment_id', None)
        self.policy_definition_id = kwargs.get('policy_definition_id', None)
        self.effective_parameters = kwargs.get('effective_parameters', None)
        self.is_compliant = kwargs.get('is_compliant', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_location = kwargs.get('resource_location', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.resource_tags = kwargs.get('resource_tags', None)
        self.policy_assignment_name = kwargs.get('policy_assignment_name', None)
        self.policy_assignment_owner = kwargs.get('policy_assignment_owner', None)
        self.policy_assignment_parameters = kwargs.get('policy_assignment_parameters', None)
        self.policy_assignment_scope = kwargs.get('policy_assignment_scope', None)
        self.policy_definition_name = kwargs.get('policy_definition_name', None)
        self.policy_definition_action = kwargs.get('policy_definition_action', None)
        self.policy_definition_category = kwargs.get('policy_definition_category', None)
        self.policy_set_definition_id = kwargs.get('policy_set_definition_id', None)
        self.policy_set_definition_name = kwargs.get('policy_set_definition_name', None)
        self.policy_set_definition_owner = kwargs.get('policy_set_definition_owner', None)
        self.policy_set_definition_category = kwargs.get('policy_set_definition_category', None)
        self.policy_set_definition_parameters = kwargs.get('policy_set_definition_parameters', None)
        self.management_group_ids = kwargs.get('management_group_ids', None)
        self.policy_definition_reference_id = kwargs.get('policy_definition_reference_id', None)
        self.compliance_state = kwargs.get('compliance_state', None)
        self.policy_evaluation_details = kwargs.get('policy_evaluation_details', None)
        self.policy_definition_group_names = kwargs.get('policy_definition_group_names', None)
        self.components = kwargs.get('components', None)
        self.policy_definition_version = None
        self.policy_set_definition_version = None
        self.policy_assignment_version = None


class PolicyStatesQueryResults(msrest.serialization.Model):
    """Query results.

    :param odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :type odata_context: str
    :param odata_count: OData entity count; represents the number of policy state records returned.
    :type odata_count: int
    :param odata_next_link: Odata next link; URL to get the next set of results.
    :type odata_next_link: str
    :param value: Query results.
    :type value: list[~azure.mgmt.policyinsights.models.PolicyState]
    """

    _validation = {
        'odata_count': {'minimum': 0},
    }

    _attribute_map = {
        'odata_context': {'key': '@odata\\.context', 'type': 'str'},
        'odata_count': {'key': '@odata\\.count', 'type': 'int'},
        'odata_next_link': {'key': '@odata\\.nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[PolicyState]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyStatesQueryResults, self).__init__(**kwargs)
        self.odata_context = kwargs.get('odata_context', None)
        self.odata_count = kwargs.get('odata_count', None)
        self.odata_next_link = kwargs.get('odata_next_link', None)
        self.value = kwargs.get('value', None)


class PolicyTrackedResource(msrest.serialization.Model):
    """Policy tracked resource record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tracked_resource_id: The ID of the policy tracked resource.
    :vartype tracked_resource_id: str
    :ivar policy_details: The details of the policy that require the tracked resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar created_by: The details of the policy triggered deployment that created the tracked
     resource.
    :vartype created_by: ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_modified_by: The details of the policy triggered deployment that modified the
     tracked resource.
    :vartype last_modified_by: ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_update_utc: Timestamp of the last update to the tracked resource.
    :vartype last_update_utc: ~datetime.datetime
    """

    _validation = {
        'tracked_resource_id': {'readonly': True},
        'policy_details': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_update_utc': {'readonly': True},
    }

    _attribute_map = {
        'tracked_resource_id': {'key': 'trackedResourceId', 'type': 'str'},
        'policy_details': {'key': 'policyDetails', 'type': 'PolicyDetails'},
        'created_by': {'key': 'createdBy', 'type': 'TrackedResourceModificationDetails'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'TrackedResourceModificationDetails'},
        'last_update_utc': {'key': 'lastUpdateUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyTrackedResource, self).__init__(**kwargs)
        self.tracked_resource_id = None
        self.policy_details = None
        self.created_by = None
        self.last_modified_by = None
        self.last_update_utc = None


class PolicyTrackedResourcesQueryResults(msrest.serialization.Model):
    """Query results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Query results.
    :vartype value: list[~azure.mgmt.policyinsights.models.PolicyTrackedResource]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyTrackedResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyTrackedResourcesQueryResults, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class QueryFailure(msrest.serialization.Model):
    """Error response.

    :param error: Error definition.
    :type error: ~azure.mgmt.policyinsights.models.QueryFailureError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'QueryFailureError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryFailure, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class QueryFailureError(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryFailureError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class QueryOptions(msrest.serialization.Model):
    """Parameter group.

    :param top: Maximum number of records to return.
    :type top: int
    :param filter: OData filter expression.
    :type filter: str
    :param order_by: Ordering expression using OData notation. One or more comma-separated column
     names with an optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId,
     ResourceId asc".
    :type order_by: str
    :param select: Select expression using OData notation. Limits the columns on each record to
     just those requested, e.g. "$select=PolicyAssignmentId, ResourceId".
    :type select: str
    :param from_property: ISO 8601 formatted timestamp specifying the start time of the interval to
     query. When not specified, the service uses ($to - 1-day).
    :type from_property: ~datetime.datetime
    :param to: ISO 8601 formatted timestamp specifying the end time of the interval to query. When
     not specified, the service uses request time.
    :type to: ~datetime.datetime
    :param apply: OData apply expression for aggregations.
    :type apply: str
    :param skip_token: Skiptoken is only provided if a previous response returned a partial result
     as a part of nextLink element.
    :type skip_token: str
    :param expand: The $expand query parameter. For example, to expand components use
     $expand=components.
    :type expand: str
    """

    _validation = {
        'top': {'minimum': 0},
    }

    _attribute_map = {
        'top': {'key': 'Top', 'type': 'int'},
        'filter': {'key': 'Filter', 'type': 'str'},
        'order_by': {'key': 'OrderBy', 'type': 'str'},
        'select': {'key': 'Select', 'type': 'str'},
        'from_property': {'key': 'FromProperty', 'type': 'iso-8601'},
        'to': {'key': 'To', 'type': 'iso-8601'},
        'apply': {'key': 'Apply', 'type': 'str'},
        'skip_token': {'key': 'SkipToken', 'type': 'str'},
        'expand': {'key': 'Expand', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryOptions, self).__init__(**kwargs)
        self.top = kwargs.get('top', None)
        self.filter = kwargs.get('filter', None)
        self.order_by = kwargs.get('order_by', None)
        self.select = kwargs.get('select', None)
        self.from_property = kwargs.get('from_property', None)
        self.to = kwargs.get('to', None)
        self.apply = kwargs.get('apply', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.expand = kwargs.get('expand', None)


class Remediation(msrest.serialization.Model):
    """The remediation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the remediation.
    :vartype id: str
    :ivar type: The type of the remediation.
    :vartype type: str
    :ivar name: The name of the remediation.
    :vartype name: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.policyinsights.models.SystemData
    :param policy_assignment_id: The resource ID of the policy assignment that should be
     remediated.
    :type policy_assignment_id: str
    :param policy_definition_reference_id: The policy definition reference ID of the individual
     definition that should be remediated. Required when the policy assignment being remediated
     assigns a policy set definition.
    :type policy_definition_reference_id: str
    :param resource_discovery_mode: The way resources to remediate are discovered. Defaults to
     ExistingNonCompliant if not specified. Possible values include: "ExistingNonCompliant",
     "ReEvaluateCompliance".
    :type resource_discovery_mode: str or ~azure.mgmt.policyinsights.models.ResourceDiscoveryMode
    :ivar provisioning_state: The status of the remediation.
    :vartype provisioning_state: str
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The time at which the remediation was last updated.
    :vartype last_updated_on: ~datetime.datetime
    :param filters: The filters that will be applied to determine which resources to remediate.
    :type filters: ~azure.mgmt.policyinsights.models.RemediationFilters
    :ivar deployment_status: The deployment status summary for all deployments created by the
     remediation.
    :vartype deployment_status: ~azure.mgmt.policyinsights.models.RemediationDeploymentSummary
    :ivar status_message: The remediation status message. Provides additional details regarding the
     state of the remediation.
    :vartype status_message: str
    :ivar correlation_id: The remediation correlation Id. Can be used to find events related to the
     remediation in the activity log.
    :vartype correlation_id: str
    :param resource_count: Determines the max number of resources that can be remediated by the
     remediation job. If not provided, the default resource count is used.
    :type resource_count: int
    :param parallel_deployments: Determines how many resources to remediate at any given time. Can
     be used to increase or reduce the pace of the remediation. If not provided, the default
     parallel deployments value is used.
    :type parallel_deployments: int
    :param failure_threshold: The remediation failure threshold settings.
    :type failure_threshold:
     ~azure.mgmt.policyinsights.models.RemediationPropertiesFailureThreshold
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'last_updated_on': {'readonly': True},
        'deployment_status': {'readonly': True},
        'status_message': {'readonly': True},
        'correlation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'policy_assignment_id': {'key': 'properties.policyAssignmentId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'properties.policyDefinitionReferenceId', 'type': 'str'},
        'resource_discovery_mode': {'key': 'properties.resourceDiscoveryMode', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'properties.lastUpdatedOn', 'type': 'iso-8601'},
        'filters': {'key': 'properties.filters', 'type': 'RemediationFilters'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'RemediationDeploymentSummary'},
        'status_message': {'key': 'properties.statusMessage', 'type': 'str'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'resource_count': {'key': 'properties.resourceCount', 'type': 'int'},
        'parallel_deployments': {'key': 'properties.parallelDeployments', 'type': 'int'},
        'failure_threshold': {'key': 'properties.failureThreshold', 'type': 'RemediationPropertiesFailureThreshold'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Remediation, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.system_data = None
        self.policy_assignment_id = kwargs.get('policy_assignment_id', None)
        self.policy_definition_reference_id = kwargs.get('policy_definition_reference_id', None)
        self.resource_discovery_mode = kwargs.get('resource_discovery_mode', None)
        self.provisioning_state = None
        self.created_on = None
        self.last_updated_on = None
        self.filters = kwargs.get('filters', None)
        self.deployment_status = None
        self.status_message = None
        self.correlation_id = None
        self.resource_count = kwargs.get('resource_count', None)
        self.parallel_deployments = kwargs.get('parallel_deployments', None)
        self.failure_threshold = kwargs.get('failure_threshold', None)


class RemediationDeployment(msrest.serialization.Model):
    """Details of a single deployment created by the remediation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar remediated_resource_id: Resource ID of the resource that is being remediated by the
     deployment.
    :vartype remediated_resource_id: str
    :ivar deployment_id: Resource ID of the template deployment that will remediate the resource.
    :vartype deployment_id: str
    :ivar status: Status of the remediation deployment.
    :vartype status: str
    :ivar resource_location: Location of the resource that is being remediated.
    :vartype resource_location: str
    :ivar error: Error encountered while remediated the resource.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The time at which the remediation deployment was last updated.
    :vartype last_updated_on: ~datetime.datetime
    """

    _validation = {
        'remediated_resource_id': {'readonly': True},
        'deployment_id': {'readonly': True},
        'status': {'readonly': True},
        'resource_location': {'readonly': True},
        'error': {'readonly': True},
        'created_on': {'readonly': True},
        'last_updated_on': {'readonly': True},
    }

    _attribute_map = {
        'remediated_resource_id': {'key': 'remediatedResourceId', 'type': 'str'},
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdatedOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemediationDeployment, self).__init__(**kwargs)
        self.remediated_resource_id = None
        self.deployment_id = None
        self.status = None
        self.resource_location = None
        self.error = None
        self.created_on = None
        self.last_updated_on = None


class RemediationDeploymentsListResult(msrest.serialization.Model):
    """List of deployments for a remediation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of deployments for the remediation.
    :vartype value: list[~azure.mgmt.policyinsights.models.RemediationDeployment]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RemediationDeployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemediationDeploymentsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RemediationDeploymentSummary(msrest.serialization.Model):
    """The deployment status summary for all deployments created by the remediation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_deployments: The number of deployments required by the remediation.
    :vartype total_deployments: int
    :ivar successful_deployments: The number of deployments required by the remediation that have
     succeeded.
    :vartype successful_deployments: int
    :ivar failed_deployments: The number of deployments required by the remediation that have
     failed.
    :vartype failed_deployments: int
    """

    _validation = {
        'total_deployments': {'readonly': True},
        'successful_deployments': {'readonly': True},
        'failed_deployments': {'readonly': True},
    }

    _attribute_map = {
        'total_deployments': {'key': 'totalDeployments', 'type': 'int'},
        'successful_deployments': {'key': 'successfulDeployments', 'type': 'int'},
        'failed_deployments': {'key': 'failedDeployments', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemediationDeploymentSummary, self).__init__(**kwargs)
        self.total_deployments = None
        self.successful_deployments = None
        self.failed_deployments = None


class RemediationFilters(msrest.serialization.Model):
    """The filters that will be applied to determine which resources to remediate.

    :param locations: The resource locations that will be remediated.
    :type locations: list[str]
    """

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemediationFilters, self).__init__(**kwargs)
        self.locations = kwargs.get('locations', None)


class RemediationListResult(msrest.serialization.Model):
    """List of remediations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of remediation definitions.
    :vartype value: list[~azure.mgmt.policyinsights.models.Remediation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Remediation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemediationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RemediationPropertiesFailureThreshold(msrest.serialization.Model):
    """The remediation failure threshold settings.

    :param percentage: A number between 0.0 to 1.0 representing the percentage failure threshold.
     The remediation will fail if the percentage of failed remediation operations (i.e. failed
     deployments) exceeds this threshold.
    :type percentage: float
    """

    _attribute_map = {
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemediationPropertiesFailureThreshold, self).__init__(**kwargs)
        self.percentage = kwargs.get('percentage', None)


class SlimPolicyMetadata(msrest.serialization.Model):
    """Slim version of policy metadata resource definition, excluding properties with large strings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy metadata.
    :vartype id: str
    :ivar type: The type of the policy metadata.
    :vartype type: str
    :ivar name: The name of the policy metadata.
    :vartype name: str
    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: any
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'metadata_id': {'readonly': True},
        'category': {'readonly': True},
        'title': {'readonly': True},
        'owner': {'readonly': True},
        'additional_content_url': {'readonly': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'metadata_id': {'key': 'properties.metadataId', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'owner': {'key': 'properties.owner', 'type': 'str'},
        'additional_content_url': {'key': 'properties.additionalContentUrl', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlimPolicyMetadata, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.metadata_id = None
        self.category = None
        self.title = None
        self.owner = None
        self.additional_content_url = None
        self.metadata = None


class SummarizeResults(msrest.serialization.Model):
    """Summarize action results.

    :param odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :type odata_context: str
    :param odata_count: OData entity count; represents the number of summaries returned; always set
     to 1.
    :type odata_count: int
    :param value: Summarize action results.
    :type value: list[~azure.mgmt.policyinsights.models.Summary]
    """

    _validation = {
        'odata_count': {'maximum': 1, 'minimum': 1},
    }

    _attribute_map = {
        'odata_context': {'key': '@odata\\.context', 'type': 'str'},
        'odata_count': {'key': '@odata\\.count', 'type': 'int'},
        'value': {'key': 'value', 'type': '[Summary]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SummarizeResults, self).__init__(**kwargs)
        self.odata_context = kwargs.get('odata_context', None)
        self.odata_count = kwargs.get('odata_count', None)
        self.value = kwargs.get('value', None)


class Summary(msrest.serialization.Model):
    """Summary results.

    :param odata_id: OData entity ID; always set to null since summaries do not have an entity ID.
    :type odata_id: str
    :param odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :type odata_context: str
    :param results: Compliance summary for all policy assignments.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    :param policy_assignments: Policy assignments summary.
    :type policy_assignments: list[~azure.mgmt.policyinsights.models.PolicyAssignmentSummary]
    """

    _attribute_map = {
        'odata_id': {'key': '@odata\\.id', 'type': 'str'},
        'odata_context': {'key': '@odata\\.context', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
        'policy_assignments': {'key': 'policyAssignments', 'type': '[PolicyAssignmentSummary]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Summary, self).__init__(**kwargs)
        self.odata_id = kwargs.get('odata_id', None)
        self.odata_context = kwargs.get('odata_context', None)
        self.results = kwargs.get('results', None)
        self.policy_assignments = kwargs.get('policy_assignments', None)


class SummaryResults(msrest.serialization.Model):
    """Compliance summary on a particular summary level.

    :param query_results_uri: HTTP POST URI for queryResults action on Microsoft.PolicyInsights to
     retrieve raw results for the compliance summary. This property will not be available by default
     in future API versions, but could be queried explicitly.
    :type query_results_uri: str
    :param non_compliant_resources: Number of non-compliant resources.
    :type non_compliant_resources: int
    :param non_compliant_policies: Number of non-compliant policies.
    :type non_compliant_policies: int
    :param resource_details: The resources summary at this level.
    :type resource_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    :param policy_details: The policy artifact summary at this level. For query scope level, it
     represents policy assignment summary. For policy assignment level, it represents policy
     definitions summary.
    :type policy_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    :param policy_group_details: The policy definition group summary at this level.
    :type policy_group_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    """

    _validation = {
        'non_compliant_resources': {'minimum': 0},
        'non_compliant_policies': {'minimum': 0},
    }

    _attribute_map = {
        'query_results_uri': {'key': 'queryResultsUri', 'type': 'str'},
        'non_compliant_resources': {'key': 'nonCompliantResources', 'type': 'int'},
        'non_compliant_policies': {'key': 'nonCompliantPolicies', 'type': 'int'},
        'resource_details': {'key': 'resourceDetails', 'type': '[ComplianceDetail]'},
        'policy_details': {'key': 'policyDetails', 'type': '[ComplianceDetail]'},
        'policy_group_details': {'key': 'policyGroupDetails', 'type': '[ComplianceDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SummaryResults, self).__init__(**kwargs)
        self.query_results_uri = kwargs.get('query_results_uri', None)
        self.non_compliant_resources = kwargs.get('non_compliant_resources', None)
        self.non_compliant_policies = kwargs.get('non_compliant_policies', None)
        self.resource_details = kwargs.get('resource_details', None)
        self.policy_details = kwargs.get('policy_details', None)
        self.policy_group_details = kwargs.get('policy_group_details', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.policyinsights.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.policyinsights.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TrackedResourceModificationDetails(msrest.serialization.Model):
    """The details of the policy triggered deployment that created or modified the tracked resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_details: The details of the policy that created or modified the tracked resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar deployment_id: The ID of the deployment that created or modified the tracked resource.
    :vartype deployment_id: str
    :ivar deployment_time: Timestamp of the deployment that created or modified the tracked
     resource.
    :vartype deployment_time: ~datetime.datetime
    """

    _validation = {
        'policy_details': {'readonly': True},
        'deployment_id': {'readonly': True},
        'deployment_time': {'readonly': True},
    }

    _attribute_map = {
        'policy_details': {'key': 'policyDetails', 'type': 'PolicyDetails'},
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'deployment_time': {'key': 'deploymentTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResourceModificationDetails, self).__init__(**kwargs)
        self.policy_details = None
        self.deployment_id = None
        self.deployment_time = None


class TypedErrorInfo(msrest.serialization.Model):
    """Scenario specific error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of included error details.
    :vartype type: str
    :ivar info: The scenario specific error details.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TypedErrorInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None
