/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.log;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import junit.framework.TestCase;
import org.openqa.selenium.server.log.ShortTermMemoryHandler;

public class ShortTermMemoryHandlerUnitTest
extends TestCase {
    public void testRecordsReturnsAnEmptyArrayWhenNoRecordHasBeenAdded() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.FINEST, null);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)0, (int)handler.records().length);
    }

    public void testRecordsReturnsTheAddedRecordWhenASingleOneIsPublished() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.FINEST, null);
        LogRecord theLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(theLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)1, (int)handler.records().length);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)theLogRecord, (Object)handler.records()[0]);
    }

    public void testRecordsIsEmptyWhenAddedRecordIsLowerThanTheMinimumLevel() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.INFO, null);
        LogRecord theLogRecord = new LogRecord(Level.FINE, "");
        handler.publish(theLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)0, (int)handler.records().length);
    }

    public void testRecordsIsEmptyWhenAddedRecordIsEqualToTheMinimumLevel() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.INFO, null);
        LogRecord theLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(theLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)1, (int)handler.records().length);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)theLogRecord, (Object)handler.records()[0]);
    }

    public void testRecordsReturnsTheTwoAddedRecordWhenATwoRecordsArePublishedAndCapacityIsNotExceeded() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(2, Level.FINEST, null);
        LogRecord firstLogRecord = new LogRecord(Level.INFO, "");
        LogRecord secondLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(firstLogRecord);
        handler.publish(secondLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)2, (int)handler.records().length);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)firstLogRecord, (Object)handler.records()[0]);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)secondLogRecord, (Object)handler.records()[1]);
    }

    public void testRecordsOnlyReturnsTheLastRecordWhenATwoRecordsArePublishedAndCapacityIsExceeded() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.FINEST, null);
        LogRecord firstLogRecord = new LogRecord(Level.INFO, "");
        LogRecord secondLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(firstLogRecord);
        handler.publish(secondLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)1, (int)handler.records().length);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)secondLogRecord, (Object)handler.records()[0]);
    }

    public void testRecordsOnlyReturnsTheLastTwoRecordsWhenThreeRecordsArePublishedAndCapacityIsExceeded() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(2, Level.FINEST, null);
        LogRecord firstLogRecord = new LogRecord(Level.INFO, "");
        LogRecord secondLogRecord = new LogRecord(Level.INFO, "");
        LogRecord thirdLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(firstLogRecord);
        handler.publish(secondLogRecord);
        handler.publish(thirdLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)2, (int)handler.records().length);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)secondLogRecord, (Object)handler.records()[0]);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)thirdLogRecord, (Object)handler.records()[1]);
    }

    public void testRecordsOnlyReturnsTheLastRecordWhenThreeRecordsArePublishedAndCapacityIsOne() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.FINEST, null);
        LogRecord firstLogRecord = new LogRecord(Level.INFO, "");
        LogRecord secondLogRecord = new LogRecord(Level.INFO, "");
        LogRecord thirdLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(firstLogRecord);
        handler.publish(secondLogRecord);
        handler.publish(thirdLogRecord);
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)1, (int)handler.records().length);
        ShortTermMemoryHandlerUnitTest.assertEquals((Object)thirdLogRecord, (Object)handler.records()[0]);
    }

    public void testAfterCloseAllRecordsAreCleared() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(2, Level.FINEST, null);
        LogRecord firstLogRecord = new LogRecord(Level.INFO, "");
        LogRecord secondLogRecord = new LogRecord(Level.INFO, "");
        handler.publish(firstLogRecord);
        handler.publish(secondLogRecord);
        handler.close();
        ShortTermMemoryHandlerUnitTest.assertNotNull((Object)handler.records());
        ShortTermMemoryHandlerUnitTest.assertEquals((int)0, (int)handler.records().length);
    }

    public void testFormattedRecordsReturnsAnEmptyStringWhenThereIsNoRecord() {
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(1, Level.INFO, null);
        ShortTermMemoryHandlerUnitTest.assertEquals((String)"", (String)handler.formattedRecords());
    }

    public void testFormattedRecords() {
        Formatter formatter = new Formatter(){

            public String format(LogRecord record) {
                return "[FORMATTED] " + record.getMessage();
            }
        };
        ShortTermMemoryHandler handler = new ShortTermMemoryHandler(2, Level.INFO, formatter);
        LogRecord firstLogRecord = new LogRecord(Level.INFO, "First log message");
        LogRecord secondLogRecord = new LogRecord(Level.INFO, "Second log message");
        handler.publish(firstLogRecord);
        handler.publish(secondLogRecord);
        ShortTermMemoryHandlerUnitTest.assertEquals((String)"[FORMATTED] First log message\n[FORMATTED] Second log message\n", (String)handler.formattedRecords());
    }
}

