# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ApiOperation(Model):
    """REST API operation description: see
    https://github.com/Azure/azure-rest-api-specs/blob/master/documentation/openapi-authoring-automated-guidelines.md#r3023-operationsapiimplementation.

    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.storagecache.models.ApiOperationDisplay
    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'ApiOperationDisplay'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, display=None, name: str=None, **kwargs) -> None:
        super(ApiOperation, self).__init__(**kwargs)
        self.display = display
        self.name = name


class ApiOperationDisplay(Model):
    """The object that represents the operation.

    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param provider: Service provider: Microsoft.StorageCache
    :type provider: str
    :param resource: Resource on which the operation is performed: cache, etc.
    :type resource: str
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(self, *, operation: str=None, provider: str=None, resource: str=None, **kwargs) -> None:
        super(ApiOperationDisplay, self).__init__(**kwargs)
        self.operation = operation
        self.provider = provider
        self.resource = resource


class Cache(Model):
    """A cache instance.  Follows Azure Resource Manager standards:
    https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: ARM tags as name/value pairs.
    :type tags: object
    :ivar id: Fully qualified URL of the cache.
    :vartype id: str
    :param location: Region name string.
    :type location: str
    :ivar name: Name of cache.
    :vartype name: str
    :ivar type: Type for the cache; Microsoft.StorageCache/Cache
    :vartype type: str
    :param cache_size_gb: The size of this cache's cache, in GB.
    :type cache_size_gb: int
    :ivar health: Health of the cache.
    :vartype health: ~azure.mgmt.storagecache.models.CacheHealth
    :ivar mount_addresses: Array of IP addresses that can be used by clients
     mounting this Cache.
    :vartype mount_addresses: list[str]
    :param provisioning_state: ARM provisioning state, see
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
     Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Creating',
     'Deleting', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.storagecache.models.ProvisioningStateType
    :param subnet: Subnet used for the cache.
    :type subnet: str
    :param upgrade_status: Upgrade status of the cache.
    :type upgrade_status: ~azure.mgmt.storagecache.models.CacheUpgradeStatus
    :param sku: Sku for the cache.
    :type sku: ~azure.mgmt.storagecache.models.CacheSku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'health': {'readonly': True},
        'mount_addresses': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': 'object'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cache_size_gb': {'key': 'properties.cacheSizeGB', 'type': 'int'},
        'health': {'key': 'properties.health', 'type': 'CacheHealth'},
        'mount_addresses': {'key': 'properties.mountAddresses', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'str'},
        'upgrade_status': {'key': 'properties.upgradeStatus', 'type': 'CacheUpgradeStatus'},
        'sku': {'key': 'sku', 'type': 'CacheSku'},
    }

    def __init__(self, *, tags=None, location: str=None, cache_size_gb: int=None, provisioning_state=None, subnet: str=None, upgrade_status=None, sku=None, **kwargs) -> None:
        super(Cache, self).__init__(**kwargs)
        self.tags = tags
        self.id = None
        self.location = location
        self.name = None
        self.type = None
        self.cache_size_gb = cache_size_gb
        self.health = None
        self.mount_addresses = None
        self.provisioning_state = provisioning_state
        self.subnet = subnet
        self.upgrade_status = upgrade_status
        self.sku = sku


class CacheHealth(Model):
    """An indication of cache health.  Gives more information about health than
    just that related to provisioning.

    :param state: List of cache health states. Possible values include:
     'Unknown', 'Healthy', 'Degraded', 'Down', 'Transitioning', 'Stopping',
     'Stopped', 'Upgrading', 'Flushing'
    :type state: str or ~azure.mgmt.storagecache.models.HealthStateType
    :param status_description: Describes explanation of state.
    :type status_description: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'status_description': {'key': 'statusDescription', 'type': 'str'},
    }

    def __init__(self, *, state=None, status_description: str=None, **kwargs) -> None:
        super(CacheHealth, self).__init__(**kwargs)
        self.state = state
        self.status_description = status_description


class CacheSku(Model):
    """Sku for the cache.

    :param name: Sku name for this cache.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(CacheSku, self).__init__(**kwargs)
        self.name = name


class CacheUpgradeStatus(Model):
    """Properties describing the software upgrade state of the cache.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar current_firmware_version: Version string of the firmware currently
     installed on this cache.
    :vartype current_firmware_version: str
    :ivar firmware_update_status: True if there is a firmware update ready to
     install on this cache.  The firmware will automatically be installed after
     firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
     Possible values include: 'available', 'unavailable'
    :vartype firmware_update_status: str or
     ~azure.mgmt.storagecache.models.FirmwareStatusType
    :ivar firmware_update_deadline: Time at which the pending firmware update
     will automatically be installed on the cache.
    :vartype firmware_update_deadline: datetime
    :ivar last_firmware_update: Time of the last successful firmware update.
    :vartype last_firmware_update: datetime
    :ivar pending_firmware_version: When firmwareUpdateAvailable is true, this
     field holds the version string for the update.
    :vartype pending_firmware_version: str
    """

    _validation = {
        'current_firmware_version': {'readonly': True},
        'firmware_update_status': {'readonly': True},
        'firmware_update_deadline': {'readonly': True},
        'last_firmware_update': {'readonly': True},
        'pending_firmware_version': {'readonly': True},
    }

    _attribute_map = {
        'current_firmware_version': {'key': 'currentFirmwareVersion', 'type': 'str'},
        'firmware_update_status': {'key': 'firmwareUpdateStatus', 'type': 'str'},
        'firmware_update_deadline': {'key': 'firmwareUpdateDeadline', 'type': 'iso-8601'},
        'last_firmware_update': {'key': 'lastFirmwareUpdate', 'type': 'iso-8601'},
        'pending_firmware_version': {'key': 'pendingFirmwareVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CacheUpgradeStatus, self).__init__(**kwargs)
        self.current_firmware_version = None
        self.firmware_update_status = None
        self.firmware_update_deadline = None
        self.last_firmware_update = None
        self.pending_firmware_version = None


class ClfsTarget(Model):
    """Storage container for use as a CLFS StorageTarget.

    :param target: URL of storage container.
    :type target: str
    """

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, *, target: str=None, **kwargs) -> None:
        super(ClfsTarget, self).__init__(**kwargs)
        self.target = target


class CloudError(Model):
    """An error response.

    :param error: The body of the error.
    :type error: ~azure.mgmt.storagecache.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.storagecache.models.CloudErrorBody]
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, details=None, message: str=None, target: str=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.details = details
        self.message = message
        self.target = target


class NamespaceJunction(Model):
    """A namespace junction.

    :param namespace_path: Namespace path on a cache for a storage target.
    :type namespace_path: str
    :param target_path: Path in storage target to which namespacePath points.
    :type target_path: str
    :param nfs_export: NFS export where targetPath exists.
    :type nfs_export: str
    """

    _attribute_map = {
        'namespace_path': {'key': 'namespacePath', 'type': 'str'},
        'target_path': {'key': 'targetPath', 'type': 'str'},
        'nfs_export': {'key': 'nfsExport', 'type': 'str'},
    }

    def __init__(self, *, namespace_path: str=None, target_path: str=None, nfs_export: str=None, **kwargs) -> None:
        super(NamespaceJunction, self).__init__(**kwargs)
        self.namespace_path = namespace_path
        self.target_path = target_path
        self.nfs_export = nfs_export


class Nfs3Target(Model):
    """An NFS mount point for use as a StorageTarget.

    :param target: IP or name of an NFS Storage Target host, ie: 10.0.44.44
    :type target: str
    :param usage_model: Identifies the primary usage model to be used for this
     storage target.   GET choices from .../usageModels
    :type usage_model: str
    """

    _validation = {
        'target': {'pattern': r'^[-.0-9a-zA-Z]+$'},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'usage_model': {'key': 'usageModel', 'type': 'str'},
    }

    def __init__(self, *, target: str=None, usage_model: str=None, **kwargs) -> None:
        super(Nfs3Target, self).__init__(**kwargs)
        self.target = target
        self.usage_model = usage_model


class ResourceSku(Model):
    """A resource SKU.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :param capabilities: A list of capabilities of this SKU, such as
     throughput or ops/sec
    :type capabilities:
     list[~azure.mgmt.storagecache.models.ResourceSkuCapabilities]
    :ivar locations: The set of locations that the SKU is available. This will
     be supported and registered Azure Geo Regions (e.g. West US, East US,
     Southeast Asia, etc.).
    :vartype locations: list[str]
    :param location_info: The set of locations that the SKU is available.
    :type location_info:
     list[~azure.mgmt.storagecache.models.ResourceSkuLocationInfo]
    :param name: The name of this sku.
    :type name: str
    :param restrictions: The restrictions because of which SKU cannot be used.
     This is empty if there are no restrictions.
    :type restrictions: list[~azure.mgmt.storagecache.models.Restriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'locations': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '[ResourceSkuCapabilities]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[ResourceSkuLocationInfo]'},
        'name': {'key': 'name', 'type': 'str'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(self, *, capabilities=None, location_info=None, name: str=None, restrictions=None, **kwargs) -> None:
        super(ResourceSku, self).__init__(**kwargs)
        self.resource_type = None
        self.capabilities = capabilities
        self.locations = None
        self.location_info = location_info
        self.name = name
        self.restrictions = restrictions


class ResourceSkuCapabilities(Model):
    """A resource SKU capability.

    :param name: Name of a capability, such as ops/sec
    :type name: str
    :param value: Quantity, if the capability is measured by quantity
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, value: str=None, **kwargs) -> None:
        super(ResourceSkuCapabilities, self).__init__(**kwargs)
        self.name = name
        self.value = value


class ResourceSkuLocationInfo(Model):
    """Resource SKU location information.

    :param location: Location where this Sku is available
    :type location: str
    :param zones: Zones if any.
    :type zones: list[str]
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, *, location: str=None, zones=None, **kwargs) -> None:
        super(ResourceSkuLocationInfo, self).__init__(**kwargs)
        self.location = location
        self.zones = zones


class Restriction(Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of restrictions. As of now only possible value for
     this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to
     location. This would be different locations where the SKU is restricted.
    :vartype values: list[str]
    :param reason_code: The reason for the restriction. As of now this can be
     "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU
     has requiredQuotas parameter as the subscription does not belong to that
     quota. The "NotAvailableForSubscription" is related to capacity at DC.
     Possible values include: 'QuotaId', 'NotAvailableForSubscription'
    :type reason_code: str or ~azure.mgmt.storagecache.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(self, *, reason_code=None, **kwargs) -> None:
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class StorageTarget(Model):
    """A storage system being cached by a Cache.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: A fully qualified URL.
    :vartype name: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar type: Type for the storage target;
     Microsoft.StorageCache/Cache/StorageTarget
    :vartype type: str
    :param junctions: List of cache namespace to target namespace
     associations.
    :type junctions: list[~azure.mgmt.storagecache.models.NamespaceJunction]
    :param target_type: Type for storage target. Possible values include:
     'nfs3', 'clfs', 'unknown'
    :type target_type: str or
     ~azure.mgmt.storagecache.models.StorageTargetType
    :param provisioning_state: ARM provisioning state, see
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
     Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Creating',
     'Deleting', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.storagecache.models.ProvisioningStateType
    :param nfs3: Properties when nfs3 target.
    :type nfs3: ~azure.mgmt.storagecache.models.Nfs3Target
    :param clfs: Properties when clfs target.
    :type clfs: ~azure.mgmt.storagecache.models.ClfsTarget
    :param unknown: Properties when unknown target.
    :type unknown: ~azure.mgmt.storagecache.models.UnknownTarget
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'junctions': {'key': 'properties.junctions', 'type': '[NamespaceJunction]'},
        'target_type': {'key': 'properties.targetType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'nfs3': {'key': 'properties.nfs3', 'type': 'Nfs3Target'},
        'clfs': {'key': 'properties.clfs', 'type': 'ClfsTarget'},
        'unknown': {'key': 'properties.unknown', 'type': 'UnknownTarget'},
    }

    def __init__(self, *, junctions=None, target_type=None, provisioning_state=None, nfs3=None, clfs=None, unknown=None, **kwargs) -> None:
        super(StorageTarget, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.junctions = junctions
        self.target_type = target_type
        self.provisioning_state = provisioning_state
        self.nfs3 = nfs3
        self.clfs = clfs
        self.unknown = unknown


class UnknownTarget(Model):
    """Storage container for use as a Unknown StorageTarget.

    :param unknown_map: Dictionary of string->string pairs containing
     information about the StorageTarget.
    :type unknown_map: dict[str, str]
    """

    _attribute_map = {
        'unknown_map': {'key': 'unknownMap', 'type': '{str}'},
    }

    def __init__(self, *, unknown_map=None, **kwargs) -> None:
        super(UnknownTarget, self).__init__(**kwargs)
        self.unknown_map = unknown_map


class UsageModel(Model):
    """A usage model.

    :param display: Localized information describing this usage model.
    :type display: ~azure.mgmt.storagecache.models.UsageModelDisplay
    :param model_name: Non localized keyword naming this usage model.
    :type model_name: str
    :param target_type: The type of Storage Target to which this model is
     applicable (only nfs for now)
    :type target_type: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'UsageModelDisplay'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'target_type': {'key': 'targetType', 'type': 'str'},
    }

    def __init__(self, *, display=None, model_name: str=None, target_type: str=None, **kwargs) -> None:
        super(UsageModel, self).__init__(**kwargs)
        self.display = display
        self.model_name = model_name
        self.target_type = target_type


class UsageModelDisplay(Model):
    """Localized information describing this usage model.

    :param description: String to display for this usage model.
    :type description: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, description: str=None, **kwargs) -> None:
        super(UsageModelDisplay, self).__init__(**kwargs)
        self.description = description
