# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ElasticPool(Resource):
    """Represents an Azure SQL Database elastic pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar id: Resource ID
    :vartype id: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :ivar creation_date: The creation date of the Azure SQL Elastic Pool
     (ISO8601 format).
    :vartype creation_date: datetime
    :ivar state: The state of the Azure SQL Elastic Pool. Possible values
     include: 'Creating', 'Ready', 'Disabled'
    :vartype state: str or :class:`ElasticPoolState
     <azure.mgmt.sql.models.ElasticPoolState>`
    :param edition: The edition of the Azure SQL Elastic Pool. Possible values
     include: 'Basic', 'Standard', 'Premium'
    :type edition: str or :class:`ElasticPoolEditions
     <azure.mgmt.sql.models.ElasticPoolEditions>`
    :param dtu: The total shared DTU for the SQL Azure Database Elastic Pool.
    :type dtu: int
    :param database_dtu_max: The maximum DTU any one SQL Azure Database can
     consume.
    :type database_dtu_max: int
    :param database_dtu_min: The minimum DTU all SQL Azure Databases are
     guaranteed.
    :type database_dtu_min: int
    :param storage_mb: Gets storage limit for the SQL Azure Database Elastic
     Pool in MB.
    :type storage_mb: int
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'creation_date': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'dtu': {'key': 'properties.dtu', 'type': 'int'},
        'database_dtu_max': {'key': 'properties.databaseDtuMax', 'type': 'int'},
        'database_dtu_min': {'key': 'properties.databaseDtuMin', 'type': 'int'},
        'storage_mb': {'key': 'properties.storageMB', 'type': 'int'},
    }

    def __init__(self, location, tags=None, edition=None, dtu=None, database_dtu_max=None, database_dtu_min=None, storage_mb=None):
        super(ElasticPool, self).__init__(location=location, tags=tags)
        self.creation_date = None
        self.state = None
        self.edition = edition
        self.dtu = dtu
        self.database_dtu_max = database_dtu_max
        self.database_dtu_min = database_dtu_min
        self.storage_mb = storage_mb
