# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Server(Resource):
    """Represents an Azure SQL server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar id: Resource ID
    :vartype id: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     server.
    :vartype fully_qualified_domain_name: str
    :param version: The version of the server. Possible values include: '2.0',
     '12.0'
    :type version: str or :class:`ServerVersion
     <azure.mgmt.sql.models.ServerVersion>`
    :param administrator_login: Administrator username for the server. Can
     only be specified when the server is being created (and is required for
     creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for server creation).
    :type administrator_login_password: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'fully_qualified_domain_name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
    }

    def __init__(self, location, tags=None, version=None, administrator_login=None, administrator_login_password=None):
        super(Server, self).__init__(location=location, tags=tags)
        self.fully_qualified_domain_name = None
        self.version = version
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
