# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TaskExecutionInformation(Model):
    """Information about the execution of a task.

    :param start_time: The time at which the task started running. 'Running'
     corresponds to the running state, so if the task specifies resource files
     or application packages, then the start time reflects the time at which
     the task started downloading or deploying these. If the task has been
     restarted or retried, this is the most recent time at which the task
     started running. This property is present only for tasks that are in the
     running or completed state.
    :type start_time: datetime
    :param end_time: The time at which the task completed. This property is
     set only if the task is in the Completed state.
    :type end_time: datetime
    :param exit_code: The exit code of the program specified on the task
     command line. This property is set only if the task is in the completed
     state. In general, the exit code for a process reflects the specific
     convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that
     you know the exit code convention used by the application process.
     However, if the Batch service terminates the task (due to timeout, or user
     termination via the API) you may see an operating system-defined exit
     code.
    :type exit_code: int
    :param scheduling_error: Details of any error encountered scheduling the
     task. This property is set only if the task is in the completed state.
    :type scheduling_error: :class:`TaskSchedulingError
     <azure.batch.models.TaskSchedulingError>`
    :param retry_count: The number of times the task has been retried by the
     Batch service. The task is retried if it exits with a nonzero exit code,
     up to the specified maxTaskRetryCount.
    :type retry_count: int
    :param last_retry_time: The most recent time at which a retry of the task
     started running. This element is present only if the task was retried
     (i.e. retryCount is nonzero). If present, this is typically the same as
     startTime, but may be different if the task has been restarted for reasons
     other than retry; for example, if the compute node was rebooted during a
     retry, then the startTime is updated but the lastRetryTime is not.
    :type last_retry_time: datetime
    :param requeue_count: The number of times the task has been requeued by
     the Batch service as the result of a user request. When the user removes
     nodes from a pool (by resizing/shrinking the pool) or when the job is
     being disabled, the user can specify that running tasks on the nodes be
     requeued for execution. This count tracks how many times the task has been
     requeued for these reasons.
    :type requeue_count: int
    :param last_requeue_time: The most recent time at which the task has been
     requeued by the Batch service as the result of a user request. This
     property is set only if the requeueCount is nonzero.
    :type last_requeue_time: datetime
    """

    _validation = {
        'retry_count': {'required': True},
        'requeue_count': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'scheduling_error': {'key': 'schedulingError', 'type': 'TaskSchedulingError'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'last_retry_time': {'key': 'lastRetryTime', 'type': 'iso-8601'},
        'requeue_count': {'key': 'requeueCount', 'type': 'int'},
        'last_requeue_time': {'key': 'lastRequeueTime', 'type': 'iso-8601'},
    }

    def __init__(self, retry_count, requeue_count, start_time=None, end_time=None, exit_code=None, scheduling_error=None, last_retry_time=None, last_requeue_time=None):
        self.start_time = start_time
        self.end_time = end_time
        self.exit_code = exit_code
        self.scheduling_error = scheduling_error
        self.retry_count = retry_count
        self.last_retry_time = last_retry_time
        self.requeue_count = requeue_count
        self.last_requeue_time = last_requeue_time
