# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserAccount(Model):
    """Properties used to create a user on an Azure Batch node.

    :param name: The name of the user account.
    :type name: str
    :param password: The password for the user account.
    :type password: str
    :param elevation_level: The elevation level of the user account. nonAdmin
     - The auto user is a standard user without elevated access. admin - The
     auto user is a user with elevated access and operates with full
     Administrator permissions. The default value is nonAdmin. Possible values
     include: 'nonAdmin', 'admin'
    :type elevation_level: str or :class:`ElevationLevel
     <azure.batch.models.ElevationLevel>`
    :param ssh_private_key: The SSH private key for the user account. The SSH
     private key establishes password-less SSH between nodes in a Linux pool
     when the pool's enableInterNodeCommunication property is true. This
     property will be ignored in a Windows pool.
    :type ssh_private_key: str
    """

    _validation = {
        'name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
        'ssh_private_key': {'key': 'sshPrivateKey', 'type': 'str'},
    }

    def __init__(self, name, password, elevation_level=None, ssh_private_key=None):
        self.name = name
        self.password = password
        self.elevation_level = elevation_level
        self.ssh_private_key = ssh_private_key
