/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
@XmlRootElement(name="schedulerstatus")
public enum SchedulerStatus implements Serializable
{
    STARTED("Started"),
    STOPPED("Stopped"),
    FROZEN("Frozen"),
    PAUSED("Paused"),
    SHUTTING_DOWN("Shutting down"),
    UNLINKED("Unlinked from RM"),
    KILLED("Killed"),
    DB_DOWN("Killed (DB down)");

    private String definition;

    private SchedulerStatus(String def) {
        this.definition = def;
    }

    public String toString() {
        return this.definition;
    }

    public boolean isKilled() {
        return this == KILLED || this == DB_DOWN;
    }

    public boolean isShuttingDown() {
        return this.isKilled() || this == SHUTTING_DOWN;
    }

    public boolean isUnusable() {
        return this.isKilled();
    }

    public boolean isDown() {
        return this == UNLINKED || this.isShuttingDown();
    }

    public boolean isStoppable() {
        return !this.isDown() && this != STOPPED;
    }

    public boolean isStartable() {
        return !this.isDown() && this == STOPPED;
    }

    public boolean isFreezable() {
        return !this.isDown() && (this == PAUSED || this == STARTED);
    }

    public boolean isPausable() {
        return !this.isDown() && (this == FROZEN || this == STARTED);
    }

    public boolean isResumable() {
        return !this.isDown() && (this == PAUSED || this == FROZEN);
    }

    public boolean isSubmittable() {
        return !this.isShuttingDown() && this != STOPPED;
    }
}

