/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.ow2.proactive.process_tree_killer.ProcessTree;
import org.ow2.proactive.utils.Environment;

public class CookieBasedProcessTreeKiller {
    private static final Logger logger = Logger.getLogger(CookieBasedProcessTreeKiller.class);
    private static final String PROCESS_KILLER_COOKIE = "PROCESS_KILLER_COOKIE";
    private final String cookieName;
    private final String cookieValue;

    private CookieBasedProcessTreeKiller(String cookieNameSuffix) {
        this.cookieName = PROCESS_KILLER_COOKIE + cookieNameSuffix;
        this.cookieValue = UUID.randomUUID().toString();
    }

    public static CookieBasedProcessTreeKiller createAllChildrenKiller(String cookieNameSuffix) {
        CookieBasedProcessTreeKiller killer = new CookieBasedProcessTreeKiller(cookieNameSuffix);
        Environment.setenv(killer.cookieName, killer.cookieValue, true);
        return killer;
    }

    public static CookieBasedProcessTreeKiller createProcessChildrenKiller(String cookieNameSuffix, Map<String, String> processEnvironment) {
        CookieBasedProcessTreeKiller killer = new CookieBasedProcessTreeKiller(cookieNameSuffix);
        processEnvironment.put(killer.cookieName, killer.cookieValue);
        return killer;
    }

    public void kill() {
        Environment.unsetenv(this.cookieName);
        try {
            ProcessTree.get().killAll(Collections.singletonMap(this.cookieName, this.cookieValue));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to kill child processes using cookie: " + this.cookieName), (Throwable)e);
        }
    }

    public static void registerKillChildProcessesOnShutdown(String cookieNameSuffix) {
        final CookieBasedProcessTreeKiller processKiller = CookieBasedProcessTreeKiller.createAllChildrenKiller(cookieNameSuffix);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                processKiller.kill();
            }
        });
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }
}

